/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.util.Transformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.greenhopper.web.rapid.sprint.SprintPickerModelEntry;
import com.atlassian.jira.user.ApplicationUser;

public class SprintListEntryTransformer
extends Transformer<Sprint, SprintPickerModelEntry> {
    private final SprintHelper sprintHelper;
    private final ApplicationUser user;

    public SprintListEntryTransformer(ApplicationUser user, SprintHelper sprintHelper) {
        this.sprintHelper = sprintHelper;
        this.user = user;
    }

    @Override
    protected SprintPickerModelEntry make() {
        return new SprintPickerModelEntry();
    }

    @Override
    protected void transform(Sprint sprint, SprintPickerModelEntry sprintPickerModelEntry) {
        sprintPickerModelEntry.id = sprint.getId();
        sprintPickerModelEntry.name = sprint.getName();
        sprintPickerModelEntry.boardName = this.sprintHelper.getBoardNameForSprint(this.user, sprint);
        sprintPickerModelEntry.stateKey = sprint.getState().toString().toUpperCase();
        sprintPickerModelEntry.date = sprint.getStartDate() != null ? sprint.getStartDate().toString("YYYY-MM-dd'T'HH:mm:s'Z'") : "";
    }
}

