/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.customfield.sprint.SprintPickerMatcher;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceOutcomes;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rank.RankService;
import com.atlassian.greenhopper.service.rank.RankableFactory;
import com.atlassian.greenhopper.service.rapid.RecentSprintHistoryService;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.rapid.sprint.model.UpdateSprintRequest;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintHelper {
    public static final String DATE_FORMAT_MISMATCH_CONTEXT_ID = "dateFormatMismatch";
    public static final int MIN_SUGGESTIONS = 5;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private DateTimeFormatter dateTimeFormatterFactory;
    @Autowired
    private RankService rankService;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private SprintIssueService sprintIssueService;
    @Autowired
    private RapidViewSprintQueryService rapidViewSprintQueryService;
    @Autowired
    private RankableFactory rankableFactory;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private RecentSprintHistoryService sprintHistoryService;
    @Autowired
    private SprintService sprintService;
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;
    @Autowired
    private FeatureManager featureManager;

    public ServiceOutcome<Sprint> createUpdatedSprint(ApplicationUser user, Sprint sprint, UpdateSprintRequest updateSprintRequest) {
        ServiceOutcome<Pair<DateTime, DateTime>> dates = this.parseDates(user, updateSprintRequest.startDate, updateSprintRequest.endDate);
        if (!dates.isValid()) {
            return ServiceOutcomeImpl.error(dates);
        }
        DateTime newStartDate = this.handleDateTimeUpdate(sprint.getStartDate(), (DateTime)dates.getValue().first());
        DateTime newEndDate = this.handleDateTimeUpdate(sprint.getEndDate(), (DateTime)dates.getValue().second());
        String goal = StringUtils.isBlank((CharSequence)updateSprintRequest.goal) ? null : updateSprintRequest.goal;
        Sprint updatedSprint = Sprint.builder(sprint).name(updateSprintRequest.name != null ? updateSprintRequest.name.trim() : "").startDate(newStartDate).endDate(newEndDate).goal(goal).build();
        return ServiceOutcomeImpl.ok(updatedSprint);
    }

    private DateTime handleDateTimeUpdate(DateTime origDateTime, DateTime newDateTime) {
        DateTime currentStartDateRounded;
        if (origDateTime != null && newDateTime != null && (currentStartDateRounded = origDateTime.toMutableDateTime().secondOfMinute().set(0).millisOfSecond().set(0).toDateTime()).compareTo((ReadableInstant)newDateTime) == 0) {
            return origDateTime;
        }
        return newDateTime;
    }

    public ServiceOutcome<Pair<DateTime, DateTime>> parseDates(ApplicationUser user, String startDateString, String endDateString) {
        ServiceOutcome<Option<DateTime>> endDateOutcome;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        String noneDateString = i18n.getText("gh.issue.none");
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.forUser(user).withStyle(DateTimeStyle.DATE_TIME_PICKER);
        ServiceOutcome<Option<DateTime>> startDateOutcome = this.parseDate("startDate", startDateString, noneDateString, dateTimeFormatter);
        ErrorCollection errors = new ErrorCollection();
        if (!startDateOutcome.isValid()) {
            errors.addAllErrors(startDateOutcome.getErrors());
        }
        if (!(endDateOutcome = this.parseDate("endDate", endDateString, noneDateString, dateTimeFormatter)).isValid()) {
            errors.addAllErrors(endDateOutcome.getErrors());
        }
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        DateTime startDate = (DateTime)startDateOutcome.get().getOrNull();
        DateTime endDate = (DateTime)endDateOutcome.get().getOrNull();
        return ServiceOutcomeImpl.ok(Pair.nicePairOf((Object)startDate, (Object)endDate));
    }

    private ServiceOutcome<Option<DateTime>> parseDate(String contextId, String dateString, String noneDateString, DateTimeFormatter dateTimeFormatter) {
        if (dateString == null || dateString.equals(noneDateString)) {
            return ServiceOutcomeImpl.ok(Option.none());
        }
        try {
            Date date = dateTimeFormatter.parse(dateString);
            return ServiceOutcomeImpl.ok(Option.some((Object)new DateTime((Object)date)));
        }
        catch (Exception e) {
            ErrorCollection errors = new ErrorCollection();
            errors.addContextualError(ErrorCollection.Reason.VALIDATION_FAILED, contextId, "gh.api.sprint.error.date.unparseable", dateString, dateTimeFormatter.getFormatHint());
            return ServiceOutcomeImpl.from(errors);
        }
    }

    public ServiceOutcome<Map<Sprint, List<Issue>>> calculateCurrentSprintAssignment(ApplicationUser user, List<Issue> issues) {
        HashMap sprintToIssues = Maps.newHashMap();
        for (Issue issue : issues) {
            ServiceOutcome<Option<Sprint>> activeOrFutureSprintForIssue = this.sprintIssueService.getActiveOrFutureSprintForIssue(user, issue);
            if (!activeOrFutureSprintForIssue.isValid()) {
                return ServiceOutcomeImpl.error(activeOrFutureSprintForIssue);
            }
            Option<Sprint> sprintOption = activeOrFutureSprintForIssue.getValue();
            if (!sprintOption.isDefined()) continue;
            Sprint sprint = (Sprint)sprintOption.get();
            List issuesInSprint = (List)sprintToIssues.get(sprint);
            if (issuesInSprint == null) {
                issuesInSprint = Lists.newArrayList();
                sprintToIssues.put(sprint, issuesInSprint);
            }
            issuesInSprint.add(issue);
        }
        return ServiceOutcomeImpl.ok(sprintToIssues);
    }

    public ServiceOutcome<FutureSprintMapping> getFutureSprintMapping(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<List<Sprint>> sprintsOutcome = this.rapidViewSprintQueryService.getSprints(user, rapidView, EnumSet.of(Sprint.State.FUTURE), false);
        if (!sprintsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(sprintsOutcome);
        }
        FutureSprintMapping mapping = new FutureSprintMapping(sprintsOutcome.getValue());
        return ServiceOutcomeImpl.ok(mapping);
    }

    public ServiceOutcome<Void> removeFromCurrentSprints(ApplicationUser user, Map<Sprint, List<Issue>> sprintToIssues) {
        for (Map.Entry<Sprint, List<Issue>> e : sprintToIssues.entrySet()) {
            ServiceResult outcome = this.sprintIssueService.removeIssuesFromSprint(user, e.getKey(), (Collection<Issue>)e.getValue());
            if (outcome.isValid()) continue;
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok();
    }

    public ServiceOutcome<Set<Sprint>> findSprintPickerAllMatches(ApplicationUser user, Set<Sprint> suggestions, String query, int maxResults, boolean excludeCompleted) {
        HashSet allMatches = Sets.newHashSet();
        if (this.featureManager.isEnabled(SoftwareFeatureFlags.SPRINT_PICKER_ALLSPRINTS_SUGGESTION) && suggestions.size() < 5) {
            ServiceOutcome<Set<Sprint>> sprintsByNameOutcome = this.sprintService.findSprintsByName(user, query, maxResults, excludeCompleted);
            if (sprintsByNameOutcome.isValid()) {
                for (Sprint matchCandidate : sprintsByNameOutcome.getValue()) {
                    if (suggestions.contains(matchCandidate)) continue;
                    allMatches.add(matchCandidate);
                }
            } else {
                return ServiceOutcomeImpl.error(sprintsByNameOutcome);
            }
        }
        return ServiceOutcomeImpl.ok(allMatches);
    }

    public Set<Issue> findDoneIssues(RapidView rapidView, List<Issue> issues) {
        ColumnService.ColumnProgressMap progressStatuses = this.columnService.getProgressStatuses(rapidView);
        Set<Status> doneStatuses = progressStatuses.getDone();
        HashSet doneIssues = Sets.newHashSet();
        for (Issue issue : issues) {
            if (!doneStatuses.contains(issue.getStatusObject())) continue;
            doneIssues.add(issue);
        }
        return doneIssues;
    }

    public ServiceOutcome<Void> addToNextFutureSprint(final ApplicationUser user, RapidView rapidView, Sprint sprint, List<Issue> issues, FutureSprintMapping futureSprintMapping) {
        ServiceResult addToSprintOutcome;
        Sprint nextFutureSprint = futureSprintMapping.getNextSprint(sprint);
        if (nextFutureSprint != null && !(addToSprintOutcome = this.sprintIssueService.moveIssuesToSprint(user, nextFutureSprint, issues)).isValid()) {
            return ServiceOutcomeImpl.error(addToSprintOutcome);
        }
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        ServiceOutcome<CustomField> sortedByRankFieldOutcome = ServiceOutcomes.flatMap(savedFilter, new Function<SearchRequest, ServiceOutcome<CustomField>>(){

            public ServiceOutcome<CustomField> apply(SearchRequest savedFilter) {
                return SprintHelper.this.lexoRankCustomFieldService.getValidatedCustomFieldSortedByRankField(user, savedFilter.getQuery());
            }
        });
        if (sortedByRankFieldOutcome.isValid()) {
            CustomField rankField = sortedByRankFieldOutcome.getValue();
            List<Rankable> rankables = this.rankableFactory.fromIssues(issues);
            ServiceOutcome<RankChangesOutcome> rankOutcome = this.rankService.rankFirst(user, (long)rankField.getIdAsLong(), rankables);
            if (rankOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(rankOutcome);
            }
        }
        return ServiceOutcomeImpl.ok();
    }

    public ServiceOutcome<Void> addToNextFutureSprint(ApplicationUser user, RapidView rapidView, Map<Sprint, List<Issue>> sprintToIssues, Set<Issue> doneIssues, FutureSprintMapping futureSprintMapping) {
        for (Map.Entry<Sprint, List<Issue>> entry : sprintToIssues.entrySet()) {
            ServiceOutcome<Void> outcome;
            ArrayList notDoneIssues = Lists.newArrayList();
            for (Issue issue : entry.getValue()) {
                if (doneIssues.contains(issue)) continue;
                notDoneIssues.add(issue);
            }
            if (notDoneIssues.isEmpty() || (outcome = this.addToNextFutureSprint(user, rapidView, entry.getKey(), notDoneIssues, futureSprintMapping)).isValid()) continue;
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok();
    }

    public String getBoardNameForSprint(ApplicationUser user, Sprint sprint) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, sprint.getRapidViewId());
        if (rapidView.isValid()) {
            return rapidView.getValue().getName();
        }
        return null;
    }

    public List<Sprint> findSprintsByNameInHistory(ApplicationUser user, String query, int maxResults, boolean excludeCompleted) {
        SprintPickerMatcher matcher = new SprintPickerMatcher(query, excludeCompleted);
        return this.sprintHistoryService.getRecentSprintsMatchingPredicate(user, matcher, maxResults);
    }

    public static class FutureSprintMapping {
        private List<Sprint> upcomingSprints;

        public FutureSprintMapping(List<Sprint> upcomingSprints) {
            this.upcomingSprints = upcomingSprints;
        }

        public Sprint getNextSprint(Sprint sprint) {
            int index = this.upcomingSprints.indexOf(sprint);
            if (index < 0) {
                return this.upcomingSprints.isEmpty() ? null : this.upcomingSprints.get(0);
            }
            return index + 1 < this.upcomingSprints.size() ? this.upcomingSprints.get(index + 1) : null;
        }
    }
}

