/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.sprint.RemoteSprintLinkService;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemainingService;
import com.atlassian.greenhopper.util.TimeRemainingFormatter;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEditEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.greenhopper.web.rapid.sprint.SprintListEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintPlanEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintReportEntryTransformer;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.user.ApplicationUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintEntryFactory {
    @Autowired
    private DateTimeFormatter dateTimeFormatterFactory;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private TimeRemainingFormatter timeRemainingFormatter;
    @Autowired
    private RemoteSprintLinkService remoteSprintLinkService;
    @Autowired
    private SprintHelper sprintHelper;
    @Autowired
    private SprintTimeRemainingService sprintTimeRemainingService;
    @Autowired
    private SprintPermissionService sprintPermissionService;

    public SprintBaseEntryTransformer newBaseTransformer(ApplicationUser user) {
        return new SprintBaseEntryTransformer();
    }

    public SprintEditEntryTransformer newEditTransformer(ApplicationUser user) {
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.forUser(user).withStyle(DateTimeStyle.DATE_TIME_PICKER);
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        return new SprintEditEntryTransformer(user, this.newBaseTransformer(user), this.remoteSprintLinkService, dateTimeFormatter, i18n, this.sprintPermissionService);
    }

    public SprintEditEntryTransformer newEditTransformer(ApplicationUser user, RapidView rapidView) {
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.forUser(user).withStyle(DateTimeStyle.DATE_TIME_PICKER);
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        return new SprintEditEntryTransformer(user, rapidView, this.newBaseTransformer(user), this.remoteSprintLinkService, dateTimeFormatter, i18n, this.sprintTimeRemainingService, this.sprintPermissionService);
    }

    public SprintPlanEntryTransformer newPlanTransformer(ApplicationUser user) {
        return new SprintPlanEntryTransformer(user, this.newEditTransformer(user), this.timeRemainingFormatter, this.sprintPermissionService);
    }

    public SprintReportEntryTransformer newReportTransformer(ApplicationUser user) {
        return new SprintReportEntryTransformer(this.newBaseTransformer(user));
    }

    public SprintListEntryTransformer newSprintListTransformer(ApplicationUser user) {
        return new SprintListEntryTransformer(user, this.sprintHelper);
    }
}

