/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.api.entity.remotelink.sprint.RemoteSprintLink;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.RemoteSprintLinkService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemaining;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemainingService;
import com.atlassian.greenhopper.util.Transformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEditEntry;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class SprintEditEntryTransformer
extends Transformer<Sprint, SprintEditEntry> {
    protected final ApplicationUser user;
    protected final RapidView rapidView;
    protected final SprintBaseEntryTransformer baseEntryTransformer;
    protected final RemoteSprintLinkService remoteSprintLinkService;
    protected final DateTimeFormatter dateTimeFormatter;
    protected final I18n2 i18n;
    protected final SprintTimeRemainingService sprintTimeRemainingService;
    protected final SprintPermissionService sprintPermissionService;

    public SprintEditEntryTransformer(ApplicationUser user, SprintBaseEntryTransformer baseEntryTransformer, RemoteSprintLinkService remoteSprintLinkService, DateTimeFormatter dateTimeFormatter, I18n2 i18n, SprintPermissionService sprintPermissionService) {
        this(user, null, baseEntryTransformer, remoteSprintLinkService, dateTimeFormatter, i18n, null, sprintPermissionService);
    }

    public SprintEditEntryTransformer(ApplicationUser user, RapidView rapidView, SprintBaseEntryTransformer sprintBaseEntryTransformer, RemoteSprintLinkService remoteSprintLinkService, DateTimeFormatter dateTimeFormatter, I18n2 i18n, SprintTimeRemainingService sprintTimeRemainingService, SprintPermissionService sprintPermissionService) {
        this.user = user;
        this.rapidView = rapidView;
        this.baseEntryTransformer = sprintBaseEntryTransformer;
        this.remoteSprintLinkService = remoteSprintLinkService;
        this.dateTimeFormatter = dateTimeFormatter;
        this.i18n = i18n;
        this.sprintTimeRemainingService = sprintTimeRemainingService;
        this.sprintPermissionService = sprintPermissionService;
    }

    @Override
    protected SprintEditEntry make() {
        return new SprintEditEntry();
    }

    @Override
    protected void transform(Sprint sprint, SprintEditEntry sprintEditEntry) {
        ServiceOutcome<SprintTimeRemaining> sprintTimeRemaining;
        this.baseEntryTransformer.transform(sprint, sprintEditEntry);
        sprintEditEntry.startDate = this.formatDate(sprint.getStartDate());
        sprintEditEntry.endDate = this.formatDate(sprint.getEndDate());
        sprintEditEntry.completeDate = this.formatDate(sprint.getCompleteDate());
        sprintEditEntry.remoteLinks = new ArrayList<SprintEditEntry.RemoteSprintLinkEntry>();
        sprintEditEntry.canUpdateSprint = this.sprintPermissionService.canUpdateSprint(this.user, sprint).isValid();
        sprintEditEntry.goal = sprint.getGoal();
        ServiceOutcome<List<RemoteSprintLink>> linksOutcome = this.remoteSprintLinkService.getRemoteSprintLinks(this.user, sprint);
        if (linksOutcome.isValid()) {
            for (RemoteSprintLink remoteSprintLink : linksOutcome.getValue()) {
                SprintEditEntry.RemoteSprintLinkEntry sprintLinkEntry = new SprintEditEntry.RemoteSprintLinkEntry();
                sprintLinkEntry.title = remoteSprintLink.getTitle();
                sprintLinkEntry.url = remoteSprintLink.getUrl();
                sprintEditEntry.remoteLinks.add(sprintLinkEntry);
            }
        }
        if (this.rapidView != null && (sprintTimeRemaining = this.sprintTimeRemainingService.getSprintTimeRemaining(this.user, this.rapidView, sprint.getId())).isValid()) {
            sprintEditEntry.daysRemaining = sprintTimeRemaining.getValue().days;
        }
    }

    private String formatDate(DateTime date) {
        return date != null ? this.dateTimeFormatter.format(date.toDate()) : this.i18n.getText("gh.issue.none");
    }
}

