/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.features.JiraSoftwareFeature;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.configuration.JiraSoftwareFeatureService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.sprint.ReopenSprintStats;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintStatusChangeHelper;
import com.atlassian.greenhopper.web.rapid.sprint.model.ReopenSprintRequest;
import com.atlassian.greenhopper.web.rapid.sprint.model.ReopenSprintResult;
import com.atlassian.greenhopper.web.rapid.sprint.model.ReopenSprintViewModel;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="sprint/{sprintId}/reopen")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class ReopenSprintResource
extends AbstractResource {
    private RapidViewService rapidViewService;
    private SprintService sprintService;
    private SprintPermissionService sprintPermissionService;
    private SprintStatusChangeHelper sprintStatusChangeHelper;
    private JiraAuthenticationContext authenticationContext;
    private I18nFactoryService i18nFactoryService;
    private SprintEntryFactory sprintEntryFactory;
    private final SprintIssueService sprintIssueService;
    private JiraSoftwareFeatureService jiraSoftwareFeatureService;
    private RapidViewSprintQueryService rapidViewSprintQueryService;

    public ReopenSprintResource(RapidViewService rapidViewService, SprintService sprintService, SprintPermissionService sprintPermissionService, SprintStatusChangeHelper sprintStatusChangeHelper, JiraAuthenticationContext authenticationContext, I18nFactoryService i18nFactoryService, SprintEntryFactory sprintEntryFactory, SprintIssueService sprintIssueService, JiraSoftwareFeatureService jiraSoftwareFeatureService, RapidViewSprintQueryService rapidViewSprintQueryService) {
        this.rapidViewService = rapidViewService;
        this.sprintService = sprintService;
        this.sprintPermissionService = sprintPermissionService;
        this.sprintStatusChangeHelper = sprintStatusChangeHelper;
        this.authenticationContext = authenticationContext;
        this.i18nFactoryService = i18nFactoryService;
        this.sprintEntryFactory = sprintEntryFactory;
        this.sprintIssueService = sprintIssueService;
        this.jiraSoftwareFeatureService = jiraSoftwareFeatureService;
        this.rapidViewSprintQueryService = rapidViewSprintQueryService;
    }

    @GET
    public Response getReopenModel(final @PathParam(value="sprintId") Long sprintId, final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ErrorCollection errors;
                ApplicationUser user = ReopenSprintResource.this.authenticationContext.getUser();
                I18n2 i18n = ReopenSprintResource.this.i18nFactoryService.getI18n(user);
                RapidView rapidView = ReopenSprintResource.this.check(ReopenSprintResource.this.rapidViewService.getRapidView(user, rapidViewId));
                Sprint sprint = ReopenSprintResource.this.check(ReopenSprintResource.this.sprintService.getSprint(user, sprintId));
                if (!Sprint.State.CLOSED.equals((Object)sprint.getState())) {
                    errors = new ErrorCollection();
                    ErrorCollections.checkErrors(errors.addError("gh.rapid.sprint.reopen.not_closed", new Object[0]), i18n);
                }
                if (!ReopenSprintResource.this.jiraSoftwareFeatureService.isFeatureEnabled(JiraSoftwareFeature.PARALLEL_SPRINTS) && !ReopenSprintResource.this.rapidViewSprintQueryService.getSprints(user, rapidView, EnumSet.of(Sprint.State.ACTIVE), false).get().isEmpty()) {
                    errors = new ErrorCollection();
                    ErrorCollections.checkErrors(errors.addError("gh.rapid.sprint.reopen.parallel_sprints_disabled", new Object[0]), i18n);
                }
                ReopenSprintResource.this.checkResult(ReopenSprintResource.this.sprintPermissionService.canUpdateSprint(user, sprint));
                ReopenSprintStats stats = ReopenSprintResource.this.check(ReopenSprintResource.this.sprintStatusChangeHelper.getReopenSprintStatistics(user, sprint, rapidView));
                ReopenSprintViewModel model = new ReopenSprintViewModel();
                model.rapidViewId = rapidView.getId();
                model.sprint = (SprintBaseEntry)ReopenSprintResource.this.sprintEntryFactory.newBaseTransformer(user).apply(sprint);
                model.issuesMovedBack = stats.getIssuesMovedBack();
                model.completedIssuesNotMovedBack = stats.getCompletedIssuesNotMovedBack();
                model.incompleteIssuesNotMovedBack = stats.getIncompleteIssuesNotMovedBack();
                return ReopenSprintResource.this.createOkResponse(model);
            }
        });
    }

    @PUT
    public Response reopenSprint(final ReopenSprintRequest releaseRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ErrorCollection errors;
                ApplicationUser user = ReopenSprintResource.this.authenticationContext.getUser();
                I18n2 i18n = ReopenSprintResource.this.i18nFactoryService.getI18n(user);
                ServiceOutcome<RapidView> rapidView = ReopenSprintResource.this.rapidViewService.getRapidView(user, releaseRequest.rapidViewId);
                ErrorCollections.checkErrors(rapidView.getErrors(), i18n);
                ServiceOutcome<Sprint> sprint = ReopenSprintResource.this.sprintService.getSprint(user, releaseRequest.sprintId);
                ErrorCollections.checkErrors(sprint.getErrors(), i18n);
                if (!Sprint.State.CLOSED.equals((Object)sprint.get().getState())) {
                    errors = new ErrorCollection();
                    ErrorCollections.checkErrors(errors.addError("gh.rapid.sprint.reopen.not_closed", new Object[0]), i18n);
                }
                if (!ReopenSprintResource.this.jiraSoftwareFeatureService.isFeatureEnabled(JiraSoftwareFeature.PARALLEL_SPRINTS) && !ReopenSprintResource.this.rapidViewSprintQueryService.getSprints(user, rapidView.get(), EnumSet.of(Sprint.State.ACTIVE), false).get().isEmpty()) {
                    errors = new ErrorCollection();
                    ErrorCollections.checkErrors(errors.addError("gh.rapid.sprint.reopen.parallel_sprints_disabled", new Object[0]), i18n);
                }
                ReopenSprintResource.this.checkResult(ReopenSprintResource.this.sprintPermissionService.canUpdateSprint(user, sprint.get()));
                sprint = ReopenSprintResource.this.sprintService.reopenSprint(user, sprint.get());
                ErrorCollections.checkErrors(sprint.getErrors(), i18n);
                ServiceOutcome<List<Issue>> incompleteIssuesFromSprint = ReopenSprintResource.this.sprintStatusChangeHelper.getIncompleteParentIssuesFromSprint(user, sprint.getValue(), rapidView.getValue());
                ErrorCollections.checkErrors(incompleteIssuesFromSprint.getErrors(), i18n);
                ReopenSprintResource.this.sprintIssueService.moveIncompleteIssuesBackToReopenedSprint(user, sprint.get(), (Collection<Issue>)incompleteIssuesFromSprint.get());
                ServiceOutcome<List<Issue>> completeIssuesFromSprint = ReopenSprintResource.this.sprintStatusChangeHelper.getCompletedIssuesFromSprint(user, sprint.getValue(), rapidView.getValue());
                ErrorCollections.checkErrors(completeIssuesFromSprint.getErrors(), i18n);
                ReopenSprintResource.this.sprintIssueService.moveCompleteIssuesBackToReopenedSprint(user, sprint.get(), (Collection<Issue>)completeIssuesFromSprint.get());
                Sprint newSprint = Sprint.builder(sprint.getValue()).completeDate((DateTime)null).build();
                ReopenSprintResource.this.sprintService.updateSprint(user, newSprint);
                ReopenSprintResult result = new ReopenSprintResult();
                result.message = i18n.getText("gh.sprint.reopen.confirmation");
                return ReopenSprintResource.this.createOkResponse(result);
            }
        });
    }
}

