/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.sprint;

import com.atlassian.greenhopper.issue.IssuePermissionService;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.sprint.CompleteSprintStats;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.greenhopper.web.rapid.sprint.SprintNameSuggester;
import com.atlassian.greenhopper.web.rapid.sprint.SprintStatusChangeHelper;
import com.atlassian.greenhopper.web.rapid.sprint.model.CompleteSprintRequest;
import com.atlassian.greenhopper.web.rapid.sprint.model.CompleteSprintResult;
import com.atlassian.greenhopper.web.rapid.sprint.model.CompleteSprintViewModel;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="sprint/{sprintId}/complete")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class CompleteSprintResource
extends AbstractResource {
    private static final long BACKLOG_ID = -1L;
    private static final long NEW_SPRINT_ID = -2L;
    private RapidViewService rapidViewService;
    private SprintService sprintService;
    private SprintPermissionService sprintPermissionService;
    private SprintStatusChangeHelper sprintStatusChangeHelper;
    private JiraAuthenticationContext authenticationContext;
    private I18nFactoryService i18nFactoryService;
    private SprintEntryFactory sprintEntryFactory;
    private final SprintHelper sprintHelper;
    private SprintIssueService sprintIssueService;
    private RapidViewSprintQueryService rapidViewSprintQueryService;
    private IssuePermissionService issuePermissionService;

    public CompleteSprintResource(RapidViewService rapidViewService, SprintService sprintService, SprintPermissionService sprintPermissionService, SprintStatusChangeHelper sprintStatusChangeHelper, JiraAuthenticationContext authenticationContext, I18nFactoryService i18nFactoryService, SprintEntryFactory sprintEntryFactory, SprintHelper sprintHelper, SprintIssueService sprintIssueService, RapidViewSprintQueryService rapidViewSprintQueryService, IssuePermissionService issuePermissionService) {
        this.rapidViewService = rapidViewService;
        this.sprintService = sprintService;
        this.sprintPermissionService = sprintPermissionService;
        this.sprintStatusChangeHelper = sprintStatusChangeHelper;
        this.authenticationContext = authenticationContext;
        this.i18nFactoryService = i18nFactoryService;
        this.sprintEntryFactory = sprintEntryFactory;
        this.sprintHelper = sprintHelper;
        this.sprintIssueService = sprintIssueService;
        this.rapidViewSprintQueryService = rapidViewSprintQueryService;
        this.issuePermissionService = issuePermissionService;
    }

    @GET
    public Response getCompleteModel(@PathParam(value="sprintId") Long sprintId, @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.buildCompleteModel(sprintId, rapidViewId);
    }

    @VisibleForTesting
    public Response buildCompleteModel(Long sprintId, Long rapidViewId) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, rapidViewId));
        Sprint sprint = this.check(this.sprintService.getSprint(user, sprintId));
        this.checkResult(this.sprintPermissionService.canUpdateSprint(user, sprint));
        CompleteSprintStats stats = this.check(this.sprintStatusChangeHelper.getCompleteSprintStatistics(user, sprint, rapidView));
        CompleteSprintViewModel model = new CompleteSprintViewModel();
        model.rapidViewId = rapidView.getId();
        model.completeIssues = stats.getCompleteIssueCount();
        model.incompleteIssues = stats.getIncompleteIssueCount();
        model.partiallyCompleteIssues = stats.getPartiallyCompleteIssueCount();
        model.sprint = (SprintBaseEntry)this.sprintEntryFactory.newBaseTransformer(user).apply(sprint);
        model.finishedParentsWithUnfinishedSubtasks = stats.getFinishedParentsWithUnfinishedSubtasks();
        model.unfinishedParentsWithFinishedSubtasks = stats.getUnfinishedParentKeysOfFinishedSubtasks();
        this.addIncompleteIssueDestinationsToModel(model, rapidView, user);
        return this.createOkResponse(model);
    }

    private void addIncompleteIssueDestinationsToModel(CompleteSprintViewModel model, RapidView rapidView, ApplicationUser user) {
        String backlogName = this.i18nFactoryService.getI18n(user).getText("gh.rapid.plan.backlog.name");
        String newSprintName = this.i18nFactoryService.getI18n(user).getText("gh.rapid.plan.sprint.name.new");
        List<Sprint> futureSprints = this.check(this.rapidViewSprintQueryService.getSprints(user, rapidView, EnumSet.of(Sprint.State.FUTURE), false));
        model.incompleteIssueDestinations = futureSprints.stream().map(futureSprint -> new CompleteSprintViewModel.IncompleteIssueDestination(futureSprint.getId(), futureSprint.getName())).collect(Collectors.toList());
        CompleteSprintViewModel.IncompleteIssueDestination backlogDestination = new CompleteSprintViewModel.IncompleteIssueDestination(-1L, backlogName);
        model.incompleteIssueDestinations.add(backlogDestination);
        if (this.sprintPermissionService.canCreateSprint(user, rapidView).isValid()) {
            model.incompleteIssueDestinations.add(new CompleteSprintViewModel.IncompleteIssueDestination(-2L, newSprintName));
        }
        model.defaultIncompleteIssueDestination = backlogDestination;
    }

    @PUT
    public Response completeSprint(CompleteSprintRequest releaseRequest) {
        return this.response(() -> {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, releaseRequest.rapidViewId));
            Sprint sprint = this.check(this.sprintService.getSprint(user, releaseRequest.sprintId));
            this.checkResult(this.sprintPermissionService.canUpdateSprint(user, sprint));
            CompleteSprintStats completeSprintStatistics = this.check(this.sprintStatusChangeHelper.getCompleteSprintStatistics(user, sprint, rapidView));
            if (!completeSprintStatistics.getFinishedParentsWithUnfinishedSubtasks().isEmpty()) {
                ErrorCollection errors = new ErrorCollection();
                ErrorCollections.checkErrors(errors.addError("gh.rapid.sprint.complete.incomplete.issues", StringUtils.join(completeSprintStatistics.getFinishedParentsWithUnfinishedSubtasks(), (String)", ")), i18n);
            }
            List<Issue> incompleteIssuesFromSprint = this.check(this.sprintStatusChangeHelper.getIncompleteParentIssuesFromSprint(user, sprint, rapidView));
            this.checkResult(this.sprintPermissionService.canAddRemoveIssuesToSprint(user, incompleteIssuesFromSprint));
            this.checkResult(this.issuePermissionService.canEditAllIssues(user, incompleteIssuesFromSprint));
            Sprint destinationSprint = null;
            if (releaseRequest.incompleteIssuesDestination != null) {
                if (!Arrays.asList(-1L, -2L).contains(releaseRequest.incompleteIssuesDestination)) {
                    destinationSprint = this.check(this.sprintService.getSprint(user, releaseRequest.incompleteIssuesDestination));
                }
                if (releaseRequest.incompleteIssuesDestination.equals(-2L)) {
                    destinationSprint = this.createSprint(releaseRequest.rapidViewId);
                }
            }
            Sprint updatedSprint = Sprint.builder(sprint).state(Sprint.State.CLOSED).build();
            this.check(this.sprintService.updateSprint(user, updatedSprint));
            if (destinationSprint == null) {
                this.checkResult(this.sprintIssueService.moveIssuesToBacklog(user, incompleteIssuesFromSprint));
            } else {
                this.checkResult(this.sprintIssueService.moveIssuesToSprint(user, destinationSprint, incompleteIssuesFromSprint));
            }
            CompleteSprintResult result = new CompleteSprintResult();
            result.message = i18n.getText("gh.sprint.complete.confirmation");
            return this.createOkResponse(result);
        });
    }

    @VisibleForTesting
    public Sprint createSprint(long rapidViewId) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, rapidViewId));
        List<Sprint> sprints = this.check(this.rapidViewSprintQueryService.getSprints(user, rapidView, EnumSet.allOf(Sprint.State.class), false));
        Sprint sprintObject = Sprint.builder().name(SprintNameSuggester.suggestSprintName(sprints, i18n, rapidView)).rapidViewId(rapidViewId).build();
        return this.check(this.sprintService.createSprint(user, sprintObject));
    }
}

