/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.release;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.release.ReleaseHelper;
import com.atlassian.greenhopper.web.rapid.release.ReleaseViewModel;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="release")
@Produces(value={"application/json"})
public class ReleaseResource
extends AbstractResource {
    private final ReleaseHelper releaseHelper;

    public ReleaseResource(ReleaseHelper releaseHelper) {
        this.releaseHelper = releaseHelper;
    }

    @GET
    @Path(value="model")
    public Response getModel(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="columnId") Long columnId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<ReleaseViewModel> result = ReleaseResource.this.releaseHelper.buildReleaseViewModel(ReleaseResource.this.getUser(), rapidViewId, columnId);
                ReleaseResource.this.check(result);
                return ReleaseResource.this.createOkResponse(result.getValue());
            }
        });
    }

    @POST
    @Consumes(value={"application/json"})
    public Response release(final ReleaseRequest releaseRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<ReleaseResponse> result = ReleaseResource.this.releaseHelper.release(ReleaseResource.this.getUser(), releaseRequest);
                ReleaseResource.this.check(result);
                return ReleaseResource.this.createOkResponse(result.getValue());
            }
        });
    }

    @XmlRootElement
    public static class ReleaseResponse
    extends RestTemplate {
        @XmlElement
        String message;
    }

    @XmlRootElement
    public static class ReleaseRequest
    extends RestTemplate {
        @XmlElement
        String versionName;
        @XmlElement
        String releaseDate;
        @XmlElement
        String description;
        @XmlElement
        Long rapidViewId;
        @XmlElement
        Long columnId;
    }
}

