/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.release;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.version.ReleaseService;
import com.atlassian.greenhopper.web.CurrentRequestGetter;
import com.atlassian.greenhopper.web.rapid.release.ReleaseResource;
import com.atlassian.greenhopper.web.rapid.release.ReleaseViewModel;
import com.atlassian.greenhopper.web.util.DatePickerHelper;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.joda.time.DateMidnight;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseHelper {
    @Autowired
    private DateTimeFormatterFactory dateTimeFormatterFactory;
    @Autowired
    private DatePickerHelper datePickerHelper;
    @Autowired
    private ReleaseService releaseService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private CurrentRequestGetter currentRequestGetter;

    public ServiceOutcome<ReleaseViewModel> buildReleaseViewModel(ApplicationUser user, Long rapidViewId, Long columnId) {
        DateTimeFormatter dateFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_PICKER);
        ReleaseViewModel model = new ReleaseViewModel();
        model.rapidViewId = rapidViewId;
        model.defaultReleaseDate = dateFormatter.format(new Date());
        model.datePickerFormat = this.datePickerHelper.getCalendarFormat();
        model.columnId = columnId;
        ServiceOutcome<Map<Project, Integer>> projectReleasableIssueCount = this.releaseService.getProjectReleasableIssueCount(user, rapidViewId, columnId);
        if (!projectReleasableIssueCount.isValid()) {
            return ServiceOutcomeImpl.error(projectReleasableIssueCount);
        }
        for (Map.Entry<Project, Integer> entry : projectReleasableIssueCount.getValue().entrySet()) {
            ReleaseViewModel.ProjectIssueDetails details = new ReleaseViewModel.ProjectIssueDetails();
            details.id = entry.getKey().getId();
            details.name = entry.getKey().getName();
            details.issueCount = entry.getValue();
            model.projectIssueDetails.add(details);
        }
        return ServiceOutcomeImpl.ok(model);
    }

    public ServiceOutcome<ReleaseResource.ReleaseResponse> release(ApplicationUser user, ReleaseResource.ReleaseRequest releaseRequest) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<DateMidnight> date = this.parseReleaseDate(releaseRequest.releaseDate);
        if (!date.isValid()) {
            return ServiceOutcomeImpl.error(date);
        }
        ServiceOutcome<Void> releaseVersions = this.releaseService.createAndReleaseVersion(user, releaseRequest.versionName, releaseRequest.description, date.getValue(), releaseRequest.rapidViewId, releaseRequest.columnId);
        if (!releaseVersions.isValid()) {
            return ServiceOutcomeImpl.error(releaseVersions);
        }
        ReleaseResource.ReleaseResponse releaseResponse = new ReleaseResource.ReleaseResponse();
        releaseResponse.message = i18n.getText("gh.rapid.release.success");
        return ServiceOutcomeImpl.ok(releaseResponse);
    }

    public ServiceOutcome<Void> setIssueNavigatorQuery(ApplicationUser user, Long projectId, Long rapidViewId, Long columnId) {
        HttpSession session = this.currentRequestGetter.getCurrentSession();
        if (session == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Tried setting issue navigator query in the session, but there was no session!", new Object[0]);
        }
        ServiceOutcome<SearchRequest> searchRequest = this.releaseService.getNavigatorSearch(user, projectId, rapidViewId, columnId);
        if (!searchRequest.isValid()) {
            return ServiceOutcomeImpl.from(searchRequest.getErrors());
        }
        session.setAttribute("jira.issue.navigator.search.request", (Object)searchRequest.getValue());
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<DateMidnight> parseReleaseDate(String releaseDate) {
        try {
            Date date = this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_PICKER).parse(releaseDate);
            return ServiceOutcomeImpl.ok(new DateMidnight((Object)date));
        }
        catch (IllegalArgumentException e) {
            return ServiceOutcomeImpl.error("releaseDate", ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.release.releasedate.invalid", new Object[0]);
        }
    }
}

