/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.project;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.project.ProjectType;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomes;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPresetService;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowPresets;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowService;
import com.atlassian.greenhopper.web.rapid.project.AgileProjectConfigurator;
import com.atlassian.greenhopper.web.rapid.project.ProjectCreateHookHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectCreateHookHelperImpl
implements ProjectCreateHookHelper {
    @Autowired
    private AgileProjectConfigurator agileProjectConfigurator;
    @Autowired
    private JiraAuthenticationContext authContext;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private RapidViewHelper rapidViewHelper;
    @Autowired
    private SimplifiedWorkflowService simplifiedWorkflowService;
    @Autowired
    private RapidViewPresetService rapidViewPresetService;
    @Autowired
    private ColumnService columnService;

    private ServiceOutcome<Void> configureWorkflow(ApplicationUser user, Project project, ProjectType projectType) {
        ServiceOutcome<Void> simplifiedWorkflow = this.simplifiedWorkflowService.createSimplifiedWorkflowForNewProject(user, project, SimplifiedWorkflowPresets.from(projectType));
        return simplifiedWorkflow;
    }

    private ServiceOutcome<Void> configureColumns(ApplicationUser user, RapidView rapidView, RapidViewPreset preset) {
        List<Column> defaultColumns = this.rapidViewPresetService.createColumnsForSimplifiedWorkflow(preset);
        ServiceOutcome<List<Column>> updatedColumns = this.columnService.updateColumns(user, rapidView, defaultColumns);
        return ServiceOutcomes.map(updatedColumns, new Function<List<Column>, Void>(){

            public Void apply(@Nullable List<Column> input) {
                return null;
            }
        });
    }

    @Override
    public void configureProject(Project project, FieldConfigScheme projectIssueTypeScheme, ProjectType projectType, Boolean configureWorkFlow) {
        ApplicationUser user = this.authContext.getUser();
        this.agileProjectConfigurator.configure(project, projectIssueTypeScheme, projectType);
        if (configureWorkFlow.booleanValue()) {
            this.check(this.configureWorkflow(user, project, projectType));
        }
    }

    @Override
    public RapidView configureRapidView(Project project, FieldConfigScheme projectIssueTypeScheme, RapidViewPreset rapidViewPreset, Boolean configureColumns) {
        ApplicationUser user = this.authContext.getUser();
        String boardName = this.rapidViewHelper.getDefaultBoardName(project, user);
        RapidView rapidView = this.check(this.rapidViewHelper.createDefaultRapidViewForProject(user, boardName, rapidViewPreset, project));
        if (configureColumns.booleanValue()) {
            this.check(this.configureColumns(user, rapidView, rapidViewPreset));
        }
        return rapidView;
    }

    private <T> T check(ServiceOutcome<T> outcome) {
        if (outcome.isInvalid()) {
            ErrorCollections.checkErrors(outcome.getErrors(), this.i18nFactoryService.getI18n(this.authContext.getUser()));
        }
        return outcome.getValue();
    }
}

