/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.project;

import com.atlassian.greenhopper.manager.rapidview.BoardAdminManager;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.project.ProjectType;
import com.atlassian.greenhopper.web.rapid.project.ProjectCreateHookHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.hook.AddProjectHook;
import com.atlassian.jira.project.template.hook.ConfigureData;
import com.atlassian.jira.project.template.hook.ConfigureResponse;
import com.atlassian.jira.project.template.hook.ValidateData;
import com.atlassian.jira.project.template.hook.ValidateResponse;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class GreenHopperProjectCreateHook
implements AddProjectHook {
    private static final String REDIRECT_URL = "/secure/RapidBoard.jspa?rapidView=%s";
    @Autowired
    private ProjectCreateHookHelper projectCreateHookHelper;
    @Autowired
    private BoardAdminManager boardAdminManager;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;

    public ValidateResponse validate(ValidateData validateData) {
        return ValidateResponse.create();
    }

    public ConfigureResponse configure(ConfigureData configureData) {
        Project project = configureData.project();
        this.projectCreateHookHelper.configureProject(project, configureData.issueTypeScheme(), this.getProjectType(), true);
        Optional<RapidViewPreset> rapidViewPreset = this.getRapidViewPreset();
        if (!rapidViewPreset.isPresent()) {
            return ConfigureResponse.create();
        }
        RapidView rapidView = this.projectCreateHookHelper.configureRapidView(project, configureData.issueTypeScheme(), rapidViewPreset.get(), true);
        this.addProjectLeadAsBoardAdmin(project, rapidView);
        return this.createResponseWithRedirect(rapidView.getId());
    }

    private void addProjectLeadAsBoardAdmin(Project project, RapidView rapidView) {
        if (!this.jiraAuthenticationContext.getLoggedInUser().equals((Object)project.getProjectLead())) {
            BoardAdmin projectLead = BoardAdmin.builder().key(project.getProjectLead().getKey()).type(BoardAdmin.Type.USER).build();
            this.boardAdminManager.appendBoardAdmin(rapidView, Arrays.asList(projectLead));
        }
    }

    protected ConfigureResponse createResponseWithRedirect(Long rapidViewId) {
        String redirect = String.format(REDIRECT_URL, rapidViewId);
        redirect = this.enrichRedirect(redirect);
        return ConfigureResponse.create().setRedirect(redirect);
    }

    protected abstract ProjectType getProjectType();

    protected abstract Optional<RapidViewPreset> getRapidViewPreset();

    protected String enrichRedirect(String baseRedirect) {
        return baseRedirect;
    }
}

