/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.project;

import com.atlassian.greenhopper.customfield.CustomFieldConfigurationRestorer;
import com.atlassian.greenhopper.issue.IssueTypeSchemeService;
import com.atlassian.greenhopper.project.ProjectType;
import com.atlassian.greenhopper.web.rapid.project.AgileProjectConfigurator;
import com.atlassian.jira.blueprint.api.ProjectConfigurator;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.hook.ConfigureData;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileProjectConfiguratorImpl
implements AgileProjectConfigurator {
    private static final String AGILE_PLUGIN_KEY = "com.pyxis.greenhopper.jira";
    private static final String CONFIG_FILE_LOCATION = "/projecttemplates/config/%s.json";
    @Autowired
    private CustomFieldConfigurationRestorer customFieldConfigurationRestorer;
    @Autowired
    private IssueTypeSchemeService issueTypeSchemeService;
    @Autowired
    private ProjectConfigurator projectConfigurator;

    @Override
    public void configure(Project project, ProjectType type) {
        this.fullConfiguration(project, type);
    }

    @Override
    public void configure(Project project, FieldConfigScheme projectIssueTypeScheme, ProjectType type) {
        this.extendConfiguration(project, projectIssueTypeScheme, type);
    }

    private void fullConfiguration(Project project, ProjectType type) {
        FieldConfigScheme projectIssueTypeScheme = this.getFieldConfigScheme(project, type);
        this.extendConfiguration(project, projectIssueTypeScheme, type);
    }

    private FieldConfigScheme getFieldConfigScheme(Project project, ProjectType type) {
        String configFileLocation = String.format(CONFIG_FILE_LOCATION, this.configFileName(type));
        ConfigureData configure = this.projectConfigurator.configure(project, configFileLocation, AGILE_PLUGIN_KEY);
        return configure.issueTypeScheme();
    }

    private String configFileName(ProjectType type) {
        switch (type) {
            case KANBAN: {
                return "kanban";
            }
            case SCRUM: {
                return "scrum";
            }
            case BASIC_SOFTWARE_DEVELOPMENT: {
                return "basic-software-development";
            }
        }
        throw new IllegalArgumentException("Invalid project type " + (Object)((Object)type));
    }

    void extendConfiguration(Project project, FieldConfigScheme projectIssueTypeScheme, ProjectType projectType) {
        this.customFieldConfigurationRestorer.ensureFieldsAreCorrectlyConfigured(Collections.singletonList(project), projectType, CustomFieldConfigurationRestorer.ScreenSchemeOption.UPDATE_SCREEN_SCHEME);
        switch (projectType) {
            case KANBAN: 
            case SCRUM: {
                this.issueTypeSchemeService.addAllAgileIssueTypesToScheme(projectIssueTypeScheme);
                break;
            }
            case BASIC_SOFTWARE_DEVELOPMENT: {
                this.issueTypeSchemeService.addEpicIssueTypeToScheme(projectIssueTypeScheme);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown project type " + (Object)((Object)projectType));
            }
        }
    }
}

