/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan.splitissue;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.service.issue.comment.BulkCommentService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.web.rapid.plan.SplitIssueService;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.UpdateOriginalIssueHelper;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Longs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateOriginalIssueHelperImpl
implements UpdateOriginalIssueHelper {
    private static final String CUSTOMFIELD_ID_PREFIX = "customfield_";
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private IssueUpdateService issueUpdateService;
    @Autowired
    private BulkCommentService bulkCommentService;
    @Autowired
    private CommentManager commentManager;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;

    @Override
    public ServiceResult updateOriginalIssue(Issue originalIssue, SplitIssueService.IssueData originalIssueUpdate, List<Issue> splitIssues) {
        ServiceOutcome<Issue> updateResult = this.update(originalIssue, originalIssueUpdate);
        if (updateResult.isInvalid()) {
            return ServiceOutcomeImpl.from(updateResult.getErrors());
        }
        return this.addCommentToOriginalIssue(updateResult.get(), splitIssues);
    }

    private ServiceOutcome<Issue> update(Issue originalIssue, SplitIssueService.IssueData originalIssueUpdate) {
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            IssueInputParameters issueInputParameters = this.convertToIssueUpdateParameters(originalIssue, originalIssueUpdate);
            Issue updatedIssue = ServiceOutcomeHelper.get(this.update(originalIssue.getId(), issueInputParameters));
            if ("timeoriginalestimate".equals(originalIssueUpdate.getEstimateFieldId()) && originalIssue.getEstimate() == null) {
                IssueInputParametersImpl remainingEstimateUpdateParameters = new IssueInputParametersImpl();
                remainingEstimateUpdateParameters.setRemainingEstimate(originalIssueUpdate.getEstimate());
                updatedIssue = ServiceOutcomeHelper.get(this.update(originalIssue.getId(), (IssueInputParameters)remainingEstimateUpdateParameters));
            }
            return updatedIssue;
        });
    }

    private IssueInputParameters convertToIssueUpdateParameters(Issue originalIssue, SplitIssueService.IssueData originalIssueUpdate) {
        IssueInputParametersImpl issueInputParameters = new IssueInputParametersImpl();
        issueInputParameters.setSummary(originalIssueUpdate.getSummary());
        this.applyEstimateUpdate((IssueInputParameters)issueInputParameters, originalIssueUpdate);
        this.applySprintUpdate((IssueInputParameters)issueInputParameters, originalIssue, originalIssueUpdate);
        String estimateFieldId = originalIssueUpdate.getEstimateFieldId();
        if (estimateFieldId != null) {
            if ("timeoriginalestimate".equals(estimateFieldId)) {
                issueInputParameters.setOriginalEstimate(originalIssueUpdate.getEstimate());
            } else if (estimateFieldId.startsWith(CUSTOMFIELD_ID_PREFIX)) {
                issueInputParameters.addCustomFieldValue(estimateFieldId, new String[]{originalIssueUpdate.getEstimate()});
            } else {
                throw new IllegalArgumentException("Unknown estimate field id: " + estimateFieldId);
            }
        }
        return issueInputParameters;
    }

    private void applySprintUpdate(IssueInputParameters issueInputParameters, Issue originalIssue, SplitIssueService.IssueData originalIssueUpdate) {
        Long destinationId = (Long)Longs.toLong((String)originalIssueUpdate.getDestinationId()).orNull();
        if (destinationId == null) {
            return;
        }
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        List<String> updatedSprintIds = new ArrayList<String>();
        if (originalIssue.getCustomFieldValue(defaultSprintField) != null) {
            Collection originalSprints = (Collection)originalIssue.getCustomFieldValue(defaultSprintField);
            updatedSprintIds = originalSprints.stream().filter(Sprint::isClosed).map(Sprint::getId).map(Object::toString).collect(Collectors.toList());
        }
        if (!destinationId.equals(-1L)) {
            updatedSprintIds.add(destinationId.toString());
        }
        issueInputParameters.addCustomFieldValue(defaultSprintField.getIdAsLong(), updatedSprintIds.toArray(new String[updatedSprintIds.size()]));
    }

    private void applyEstimateUpdate(IssueInputParameters issueInputParameters, SplitIssueService.IssueData originalIssueUpdate) {
        String estimateFieldId = originalIssueUpdate.getEstimateFieldId();
        if (estimateFieldId == null) {
            return;
        }
        if ("timeoriginalestimate".equals(originalIssueUpdate.getEstimateFieldId())) {
            issueInputParameters.setOriginalEstimate(originalIssueUpdate.getEstimate());
        } else if (originalIssueUpdate.getEstimateFieldId().startsWith(CUSTOMFIELD_ID_PREFIX)) {
            issueInputParameters.addCustomFieldValue(originalIssueUpdate.getEstimateFieldId(), new String[]{originalIssueUpdate.getEstimate()});
        } else {
            throw new IllegalArgumentException("Unknown estimate field id: " + originalIssueUpdate.getEstimateFieldId());
        }
    }

    @Override
    public IssueService.UpdateValidationResult validateUpdate(Issue originalIssue, SplitIssueService.IssueData updateData) {
        IssueInputParameters issueInputParameters = this.convertToIssueUpdateParameters(originalIssue, updateData);
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.issueUpdateService.validateUpdate(user, originalIssue.getId(), issueInputParameters);
    }

    private ServiceOutcome<Issue> update(long originalIssueId, IssueInputParameters issueInputParameters) {
        IssueService.UpdateValidationResult updateValidationResult = this.issueUpdateService.validateUpdate(this.jiraAuthenticationContext.getLoggedInUser(), originalIssueId, issueInputParameters);
        if (!updateValidationResult.isValid()) {
            return ServiceOutcomeImpl.from(updateValidationResult.getErrorCollection());
        }
        IssueService.IssueResult updateResult = this.issueUpdateService.update(this.jiraAuthenticationContext.getLoggedInUser(), updateValidationResult);
        if (!updateResult.isValid()) {
            return ServiceOutcomeImpl.from(updateResult.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(updateResult.getIssue());
    }

    private ServiceResult addCommentToOriginalIssue(Issue updatedOriginalIssue, List<Issue> splitIssues) {
        if (splitIssues.isEmpty() || this.commentManager.getLastComment(updatedOriginalIssue) == null) {
            return ServiceResultImpl.ok();
        }
        String comment = this.generateComment(splitIssues);
        return this.bulkCommentService.addComment(this.jiraAuthenticationContext.getLoggedInUser(), Arrays.asList(updatedOriginalIssue), comment, new CommentVisibility(null));
    }

    private String generateComment(List<Issue> splitIssues) {
        StringBuilder commentBuilder = new StringBuilder(this.jiraAuthenticationContext.getI18nHelper().getText("gh.issue.split.comment"));
        commentBuilder.append('\n');
        for (Issue splitIssue : splitIssues) {
            commentBuilder.append('|').append(splitIssue.getKey()).append('|').append(splitIssue.getSummary()).append('|').append('\n');
        }
        return commentBuilder.toString();
    }
}

