/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan.splitissue;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.SplitIssuePermissionCheckHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SplitIssuePermissionCheckHelperImpl
implements SplitIssuePermissionCheckHelper {
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private PermissionManager permissionManager;

    @Override
    public ServiceResult canSplitIssue(Issue issue) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        List<ProjectPermissionKey> requiredPermissions = Arrays.asList(ProjectPermissions.CREATE_ISSUES, ProjectPermissions.LINK_ISSUES, ProjectPermissions.EDIT_ISSUES, ProjectPermissions.SCHEDULE_ISSUES, ProjectPermissions.BROWSE_PROJECTS);
        List missingPermissions = requiredPermissions.stream().filter(p -> !this.permissionManager.hasPermission(p, issue, user)).map(p -> this.jiraAuthenticationContext.getI18nHelper().getText("admin.permissions." + p.permissionKey())).collect(Collectors.toList());
        if (missingPermissions.isEmpty()) {
            return ServiceResultImpl.ok();
        }
        return ServiceResultImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.issue.split.permission.error", Joiner.on((String)", ").join(missingPermissions));
    }
}

