/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan.splitissue;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.service.IssueIndexService;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.RankHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankHelperImpl
implements RankHelper {
    @Autowired
    private LexoRankManager lexoRankManager;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;
    @Autowired
    private IssueIndexService issueIndexService;

    @Override
    public ServiceResult rankIssues(Issue originalIssue, List<Issue> splitIssues) {
        if (splitIssues.isEmpty()) {
            return ServiceResultImpl.ok();
        }
        Long rankFieldId = this.getRankFieldId();
        Issue lastRankedIssue = originalIssue;
        HashSet issueIdsToReindex = Sets.newHashSet();
        LexoRankOperationOutcome<LexoRankChange> lastRankOutcome = null;
        int remainingIssues = splitIssues.size();
        for (Issue splitIssue : splitIssues) {
            lastRankOutcome = this.lexoRankManager.rankAfter(rankFieldId, splitIssue.getId(), lastRankedIssue.getId(), --remainingIssues);
            if (!lastRankOutcome.isValid()) break;
            issueIdsToReindex.addAll(lastRankOutcome.getIssueIdsToReIndex());
            lastRankedIssue = splitIssue;
        }
        if (!issueIdsToReindex.isEmpty()) {
            this.issueIndexService.reIndexIssuesWithIds(issueIdsToReindex);
        }
        return lastRankOutcome.isValid() ? ServiceResultImpl.ok() : ServiceResultImpl.from(lastRankOutcome.getErrors());
    }

    private Long getRankFieldId() {
        CustomField rankField = this.lexoRankCustomFieldService.getDefaultRankField();
        return rankField.getIdAsLong();
    }
}

