/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan.splitissue;

import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.issuelink.SplitIssueLinkTypeService;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.LinkSplitIssuesHelper;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LinkSplitIssuesHelperImpl
implements LinkSplitIssuesHelper {
    @Autowired
    private IssueLinkService issueLinkService;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private SplitIssueLinkTypeService splitIssueLinkTypeService;

    @Override
    public ServiceResult linkIssues(Issue originalIssue, List<Issue> splitIssues) {
        if (splitIssues.isEmpty()) {
            return ServiceResultImpl.ok();
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        IssueLinkType issueLinkType = this.splitIssueLinkTypeService.getOrCreateIssueLinkType();
        List splitIssueKeys = splitIssues.stream().map(Issue::getKey).collect(Collectors.toList());
        IssueLinkService.AddIssueLinkValidationResult addIssueLinkValidationResult = this.issueLinkService.validateAddIssueLinks(user, originalIssue, issueLinkType.getId(), Direction.OUT, splitIssueKeys, false);
        if (!addIssueLinkValidationResult.isValid()) {
            return ServiceOutcomeImpl.from(addIssueLinkValidationResult.getErrorCollection());
        }
        this.issueLinkService.addIssueLinks(user, addIssueLinkValidationResult);
        return ServiceResultImpl.ok();
    }
}

