/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan.splitissue;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.rapid.issue.IssueEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldUpdatedEntry;
import com.atlassian.greenhopper.web.rapid.plan.SplitIssueService;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.CreateSplitIssuesHelper;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Longs;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateSplitIssuesHelperImpl
implements CreateSplitIssuesHelper {
    @Autowired
    JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    EpicCustomFieldService epicCustomFieldService;
    @Autowired
    IssueFactory issueFactory;
    @Autowired
    IssueManager issueManager;
    @Autowired
    IssueEntryFactory issueEntryFactory;
    @Autowired
    SprintService sprintService;

    @Override
    public ServiceOutcome<List<Issue>> createIssues(@NotNull Issue originalIssue, @NotNull List<SplitIssueService.IssueData> newIssueAttributes) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (SplitIssueService.IssueData issueData : newIssueAttributes) {
            MutableIssue newIssue = this.getNewIssueData(originalIssue, issueData);
            try {
                Issue newlyCreatedIssue = this.issueManager.createIssueObject(user, (Issue)newIssue);
                if (StringUtils.isNotBlank((CharSequence)issueData.getEstimateFieldId())) {
                    ServiceOutcome<FieldUpdatedEntry> updateOutcome = this.issueEntryFactory.updateField(user, newlyCreatedIssue, issueData.getEstimateFieldId(), issueData.getEstimate());
                    if (updateOutcome.isInvalid()) {
                        return ServiceOutcomeImpl.from(updateOutcome.getErrors());
                    }
                    newlyCreatedIssue = this.issueManager.getIssueObject(newlyCreatedIssue.getKey());
                }
                issues.add(newlyCreatedIssue);
            }
            catch (CreateException e) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, e.getLocalizedMessage(), new Object[0]);
            }
        }
        return ServiceOutcomeImpl.ok(issues);
    }

    private MutableIssue getNewIssueData(Issue originalIssue, SplitIssueService.IssueData newIssueAttributes) {
        MutableIssue newIssue = this.issueFactory.cloneIssue(originalIssue);
        newIssue.setSummary(newIssueAttributes.getSummary());
        newIssue.setCreated(Timestamp.from(Instant.now()));
        newIssue.setUpdated(Timestamp.from(Instant.now()));
        newIssue.setVotes(null);
        newIssue.setWatches(Long.valueOf(0L));
        newIssue.setEstimate(null);
        newIssue.setOriginalEstimate(null);
        newIssue.setTimeSpent(null);
        newIssue.setResolution(null);
        newIssue.setResolutionDate(null);
        ArrayList customFieldsToCopy = Lists.newArrayList((Object[])new CustomField[]{this.epicCustomFieldService.getDefaultEpicLinkField(), this.epicCustomFieldService.getDefaultEpicColorField(), this.epicCustomFieldService.getDefaultEpicLabelField(), this.epicCustomFieldService.getDefaultEpicStatusField()});
        customFieldsToCopy.stream().forEach(customField -> newIssue.setCustomFieldValue(customField, originalIssue.getCustomFieldValue(customField)));
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        if (Strings.isNullOrEmpty((String)newIssueAttributes.getDestinationId())) {
            this.copySprintFieldOfOriginalIssue(originalIssue, newIssue, defaultSprintField);
        } else {
            Sprint sprint = this.getSprint(newIssueAttributes.getDestinationId());
            if (sprint != null) {
                newIssue.setCustomFieldValue(defaultSprintField, Arrays.asList(sprint));
            }
        }
        return newIssue;
    }

    private void copySprintFieldOfOriginalIssue(Issue originalIssue, MutableIssue newIssue, CustomField defaultSprintField) {
        Collection originalSprints = (Collection)originalIssue.getCustomFieldValue(defaultSprintField);
        if (CollectionUtils.isNotEmpty((Collection)originalSprints)) {
            List newSprints = originalSprints.stream().filter(s -> !s.isClosed()).collect(Collectors.toList());
            newIssue.setCustomFieldValue(defaultSprintField, newSprints);
        }
    }

    private Sprint getSprint(String destinationIdStr) {
        Long destinationId = (Long)Longs.toLong((String)destinationIdStr).or((Object)-1L);
        if (destinationId.equals(-1L)) {
            return null;
        }
        ServiceOutcome<Sprint> sprintOutcome = this.sprintService.getSprint(this.jiraAuthenticationContext.getLoggedInUser(), destinationId);
        return sprintOutcome.isValid() ? sprintOutcome.get() : null;
    }
}

