/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.web.rapid.plan.SplitIssueService;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.CreateSplitIssuesHelper;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.LinkSplitIssuesHelper;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.RankHelper;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.SplitIssuePermissionCheckHelper;
import com.atlassian.greenhopper.web.rapid.plan.splitissue.UpdateOriginalIssueHelper;
import com.atlassian.jira.issue.Issue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SplitIssueServiceImpl
implements SplitIssueService {
    @Autowired
    private UpdateOriginalIssueHelper updateOriginalIssueHelper;
    @Autowired
    private SplitIssuePermissionCheckHelper permissionCheckHelper;
    @Autowired
    private CreateSplitIssuesHelper createSplitIssuesHelper;
    @Autowired
    private RankHelper rankHelper;
    @Autowired
    private LinkSplitIssuesHelper linkSplitIssuesHelper;

    @Override
    public ServiceOutcome<List<Issue>> split(Issue issue, SplitIssueService.IssueData originalIssueUpdate, List<SplitIssueService.IssueData> newIssues) {
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            ServiceOutcomeHelper.validate(this.canSplit(issue));
            List<Issue> splitIssues = ServiceOutcomeHelper.get(this.createSplitIssuesHelper.createIssues(issue, newIssues));
            ServiceOutcomeHelper.validate(this.linkSplitIssuesHelper.linkIssues(issue, splitIssues));
            ServiceOutcomeHelper.validate(this.updateOriginalIssueHelper.updateOriginalIssue(issue, originalIssueUpdate, splitIssues));
            ServiceOutcomeHelper.validate(this.rankHelper.rankIssues(issue, splitIssues));
            return splitIssues;
        });
    }

    @Override
    public ServiceResult canSplit(Issue issue) {
        return this.permissionCheckHelper.canSplitIssue(issue);
    }

    @Override
    public ServiceOutcome<SplitIssueService.SplitIssueErrorReport> getUpdateErrors(Issue originalIssue, SplitIssueService.IssueData originalIssueUpdate, List<SplitIssueService.IssueData> newIssues) {
        AtomicInteger index = new AtomicInteger();
        List<SplitIssueService.SplitIssueErrorReportItem> items = Stream.concat(Stream.of(originalIssueUpdate), newIssues.stream()).map(issueData -> this.getErrors(originalIssue, (SplitIssueService.IssueData)issueData, index.getAndIncrement())).filter(item -> StringUtils.isNotBlank((CharSequence)item.errorMessageForSummary) || StringUtils.isNotBlank((CharSequence)item.errorMessageForEstimate)).collect(Collectors.toList());
        return ServiceOutcomeImpl.ok(new SplitIssueService.SplitIssueErrorReport(items.toArray(new SplitIssueService.SplitIssueErrorReportItem[0])));
    }

    private SplitIssueService.SplitIssueErrorReportItem getErrors(Issue originalIssue, SplitIssueService.IssueData issueData, int index) {
        Map errors = this.updateOriginalIssueHelper.validateUpdate(originalIssue, issueData).getErrorCollection().getErrors();
        String fieldId = issueData.getEstimateFieldId();
        String summaryErrors = errors.getOrDefault("summary", "");
        String estimateErrors = StringUtils.isNotBlank((CharSequence)fieldId) && errors.containsKey(fieldId) ? (String)errors.get(fieldId) : "";
        return new SplitIssueService.SplitIssueErrorReportItem(summaryErrors, estimateErrors, index);
    }
}

