/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.plan.SplitIssueService;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@Path(value="issue/{issueId}/split")
public class SplitIssueResource
extends AbstractResource {
    private final IssueService issueService;
    private final SplitIssueService splitIssueService;
    private final ResponseFactory responseFactory;
    private final RapidViewService rapidViewService;
    private final RapidViewSprintQueryService rapidViewSprintQueryService;
    private final SprintEntryFactory sprintEntryFactory;
    private final SprintCustomFieldService sprintCustomFieldService;
    private final I18nFactoryService i18nFactoryService;
    private final LazyReference<SprintBaseEntry> backlogSprint = new LazyReference<SprintBaseEntry>(){

        @Override
        protected SprintBaseEntry create() throws Exception {
            SprintBaseEntry backlogSprint = new SprintBaseEntry();
            backlogSprint.name = SplitIssueResource.this.i18nFactoryService.getI18n(SplitIssueResource.this.getUser()).getText("gh.rapid.plan.backlog.name");
            backlogSprint.id = -1L;
            return backlogSprint;
        }
    };

    public SplitIssueResource(IssueService issueService, SplitIssueService splitIssueService, ResponseFactory responseFactory, RapidViewService rapidViewService, RapidViewSprintQueryService rapidViewSprintQueryService, SprintEntryFactory sprintEntryFactory, SprintCustomFieldService sprintCustomFieldService, I18nFactoryService i18nFactoryService) {
        this.issueService = issueService;
        this.splitIssueService = splitIssueService;
        this.responseFactory = responseFactory;
        this.rapidViewService = rapidViewService;
        this.rapidViewSprintQueryService = rapidViewSprintQueryService;
        this.sprintEntryFactory = sprintEntryFactory;
        this.sprintCustomFieldService = sprintCustomFieldService;
        this.i18nFactoryService = i18nFactoryService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDialogData(@PathParam(value="issueId") long issueId, @QueryParam(value="rapidViewId") long rapidViewId, @QueryParam(value="getIssueDestinations") boolean getIssueDestinations) {
        return this.response(() -> this.doGetDialogData(issueId, rapidViewId, getIssueDestinations));
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response splitIssue(@PathParam(value="issueId") long issueId, SplitIssueData data) {
        return this.response(() -> {
            List<SplitIssueService.IssueData> splitIssueData;
            SplitIssueService.IssueData originalIssueUpdate;
            IssueService.IssueResult issueResult = this.getIssueResult(issueId);
            if (!issueResult.isValid()) {
                return this.responseFactory.errorsToResponse(ErrorCollection.fromJiraErrorCollectionWithReasons(issueResult.getErrorCollection()));
            }
            MutableIssue originalIssue = issueResult.getIssue();
            ServiceOutcome<SplitIssueService.SplitIssueErrorReport> report = this.splitIssueService.getUpdateErrors((Issue)originalIssue, originalIssueUpdate = data.getOriginalIssue(), splitIssueData = Arrays.asList(data.getNewIssues()));
            if (report.isInvalid()) {
                return this.responseFactory.errorsToResponse(report.getErrors());
            }
            if (report.getValue().errors.length != 0) {
                return Response.ok().entity((Object)report.get()).build();
            }
            ServiceOutcome<List<Issue>> splitResult = this.splitIssueService.split((Issue)originalIssue, originalIssueUpdate, splitIssueData);
            if (splitResult.isInvalid()) {
                return this.responseFactory.errorsToResponse(splitResult);
            }
            return Response.ok().build();
        });
    }

    private Response doGetDialogData(long issueId, long rapidViewId, boolean getIssueDestinations) {
        ServiceOutcome<RapidView> rapidViewOutcome;
        IssueService.IssueResult issueResult = this.getIssueResult(issueId);
        if (!issueResult.isValid()) {
            return this.responseFactory.errorsToResponse(ErrorCollection.fromJiraErrorCollectionWithReasons(issueResult.getErrorCollection()));
        }
        DialogData dialogData = new DialogData();
        dialogData.userHasPermissionToSplit = this.splitIssueService.canSplit((Issue)issueResult.getIssue()).isValid();
        dialogData.issueDestinations = Collections.emptyList();
        if (dialogData.userHasPermissionToSplit && getIssueDestinations && (rapidViewOutcome = this.rapidViewService.getRapidView(this.getUser(), rapidViewId)).isValid()) {
            this.appendSprintRelatedDataToDialogData((Issue)issueResult.getIssue(), dialogData, rapidViewOutcome.get());
        }
        return Response.ok((Object)dialogData).build();
    }

    private void appendSprintRelatedDataToDialogData(@Nonnull Issue issue, @Nonnull DialogData dialogData, RapidView rapidView) {
        Objects.requireNonNull(issue);
        SprintBaseEntryTransformer sprintBaseEntryTransformer = this.sprintEntryFactory.newBaseTransformer(this.getUser());
        ServiceOutcome<List<Sprint>> openSprintsOutcome = this.rapidViewSprintQueryService.getSprints(this.getUser(), rapidView, EnumSet.of(Sprint.State.ACTIVE, Sprint.State.FUTURE), false);
        if (openSprintsOutcome.isValid()) {
            this.appendIssueDestinations(dialogData, openSprintsOutcome.get(), sprintBaseEntryTransformer);
            CustomField sprintCustomField = this.sprintCustomFieldService.getDefaultSprintField();
            Optional<Collection> sprintsForIssue = Optional.ofNullable((Collection)issue.getCustomFieldValue(sprintCustomField));
            Optional<SprintBaseEntry> containingSprint = sprintsForIssue.flatMap(sprints -> sprints.stream().filter(sprint -> !sprint.isClosed()).findFirst());
            dialogData.containingSprint = containingSprint.map(sprintBaseEntryTransformer::apply).orElse(this.backlogSprint.get());
        } else {
            this.log.error(openSprintsOutcome.getErrors());
            dialogData.issueDestinations = Lists.newArrayList((Object[])new SprintBaseEntry[]{this.backlogSprint.get()});
        }
    }

    private void appendIssueDestinations(DialogData dialogData, List<Sprint> openSprints, SprintBaseEntryTransformer sprintBaseEntryTransformer) {
        dialogData.issueDestinations = Lists.newArrayList(sprintBaseEntryTransformer.apply(openSprints));
        dialogData.issueDestinations.add(this.backlogSprint.get());
    }

    private IssueService.IssueResult getIssueResult(long issueId) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return this.issueService.getIssue(user, Long.valueOf(issueId));
    }

    @JsonAutoDetect
    public static class DialogData
    extends RestTemplate {
        public boolean userHasPermissionToSplit;
        public SprintBaseEntry containingSprint;
        public List<SprintBaseEntry> issueDestinations;
    }

    @JsonAutoDetect
    public static class SplitIssueData {
        private SplitIssueService.IssueData originalIssue;
        private SplitIssueService.IssueData[] newIssues;

        public SplitIssueData() {
        }

        public SplitIssueData(SplitIssueService.IssueData originalIssue, SplitIssueService.IssueData[] newIssues) {
            this.originalIssue = originalIssue;
            this.newIssues = newIssues;
        }

        public SplitIssueService.IssueData getOriginalIssue() {
            return this.originalIssue;
        }

        public void setOriginalIssue(SplitIssueService.IssueData originalIssue) {
            this.originalIssue = originalIssue;
        }

        public SplitIssueService.IssueData[] getNewIssues() {
            return this.newIssues;
        }

        public void setNewIssues(SplitIssueService.IssueData[] newIssues) {
            this.newIssues = newIssues;
        }
    }
}

