/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankCustomFieldProvider {
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;

    @Nullable
    public Long getRankCustomFieldId(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<SearchRequest> savedFilter = this.savedFilterService.getSavedFilter(user, rapidView.getSavedFilterId());
        if (savedFilter.isInvalid()) {
            return null;
        }
        ServiceOutcome<CustomField> rankCustomField = this.lexoRankCustomFieldService.getValidatedCustomFieldSortedByRankField(user, savedFilter.get().getQuery());
        if (rankCustomField.isInvalid()) {
            return null;
        }
        return rankCustomField.get().getIdAsLong();
    }
}

