/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.query.QueryUtils;
import com.atlassian.greenhopper.model.rapid.ColumnProgress;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.ComposedIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.SprintAndIssueIdsCallback;
import com.atlassian.greenhopper.service.issue.callback.StatusProgressCallback;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.util.TimeRemainingFormatter;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.plan.PlanningDataModel;
import com.atlassian.greenhopper.web.rapid.plan.PlanningModeService;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintPlanEntry;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlanningModeServiceImpl
implements PlanningModeService {
    @Autowired
    private SearchService searchService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private DateTimeFormatterFactory dateTimeFormatterFactory;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private TimeRemainingFormatter timeRemainingFormatter;
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private SprintEntryFactory sprintEntryFactory;

    @Override
    public ServiceOutcome<PlanningModeService.Result> getBacklogIssuesAndSprintAssignment(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters) {
        SprintAndIssueIdsCallback sprintAndIssueIdCallback = new SprintAndIssueIdsCallback(this.sprintCustomFieldService.getDefaultSprintField());
        ServiceOutcome<CollectIssuesResult> openSprintIssuesResult = this.rapidIssueEntryQueryService.collectPlanModeIssues(user, rapidView, activeQuickFilters, sprintAndIssueIdCallback);
        if (!openSprintIssuesResult.isValid()) {
            return ServiceOutcomeImpl.error(openSprintIssuesResult);
        }
        PlanningModeService.Result result = new PlanningModeService.Result();
        result.issuesResult = openSprintIssuesResult.getValue();
        result.sprintToIssues = sprintAndIssueIdCallback.getSprintToIssues();
        return ServiceOutcomeImpl.ok(result);
    }

    @Override
    public ServiceOutcome<Iterable<Issue>> getTopRankedIssueInSprint(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters) {
        ServiceOutcome<Query> query = this.rapidViewQueryService.getBacklogQuery(user, rapidView);
        if (!query.isValid()) {
            return ServiceOutcomeImpl.error(query);
        }
        ServiceOutcome<ClauseToAdd> quickFilterClause = this.rapidViewQueryService.getQuickFilterClause(user, rapidView, activeQuickFilters);
        if (!query.isValid()) {
            return ServiceOutcomeImpl.error(query);
        }
        return this.searchService.findOne(user, QueryUtils.addClauses(query.getValue(), quickFilterClause.getValue()).buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<SprintPlanEntry> getCurrentSprintAndIssues(ApplicationUser user, RapidView rapidView, Long sprintId, Set<Long> activeQuickFilters) {
        ServiceOutcome<PlanningModeService.CurrentSprints> currentSprints = this.getCurrentSprintsAndIssues(user, rapidView, activeQuickFilters);
        if (!currentSprints.isValid()) {
            return ServiceOutcomeImpl.error(currentSprints);
        }
        for (SprintPlanEntry openSprint : currentSprints.getValue().getSprintsToIssues().keySet()) {
            if (!openSprint.id.equals(sprintId)) continue;
            return ServiceOutcomeImpl.ok(openSprint);
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "Unable to find sprint data for {0}", sprintId);
    }

    @Override
    public ServiceOutcome<PlanningModeService.CurrentSprints> getCurrentSprintsAndIssues(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters) {
        SprintAndIssueIdsCallback sprintAndIssueIdCallback = new SprintAndIssueIdsCallback(this.sprintCustomFieldService.getDefaultSprintField());
        ColumnService.ColumnProgressMap columnProgressMap = this.columnService.getProgressStatuses(rapidView);
        StatusProgressCallback statusProgressCallback = new StatusProgressCallback(columnProgressMap);
        ComposedIssueDataCallback composed = ComposedIssueDataCallback.of((IssueDataCallback[])new AbstractIssueDataCallback[]{sprintAndIssueIdCallback, statusProgressCallback});
        ServiceOutcome<CollectIssuesResult> openSprintIssuesResult = this.rapidIssueEntryQueryService.collectOpenSprintIssues(user, rapidView, activeQuickFilters, composed);
        if (!openSprintIssuesResult.isValid()) {
            return ServiceOutcomeImpl.error(openSprintIssuesResult);
        }
        Map<Long, List<Long>> sprintToIssues = sprintAndIssueIdCallback.getSprintToIssues();
        final Map<Long, RapidIssueEntry> issueEntryIdMap = this.getMapOfIdToEntry(openSprintIssuesResult.getValue().getIssues());
        ServiceOutcome<List<SprintPlanEntry>> sprintEntries = this.convertToSprintEntries(user, sprintAndIssueIdCallback.getSprintIds());
        if (!sprintEntries.isValid()) {
            return ServiceOutcomeImpl.error(sprintEntries);
        }
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        PlanningModeService.CurrentSprints currentSprints = new PlanningModeService.CurrentSprints();
        for (SprintPlanEntry sprintDataEntry : sprintEntries.getValue()) {
            List<Long> issueIds = sprintToIssues.get(sprintDataEntry.id);
            Iterable issueEntries = Iterables.transform(issueIds, (Function)new Function<Long, RapidIssueEntry>(){

                public RapidIssueEntry apply(Long input) {
                    return (RapidIssueEntry)issueEntryIdMap.get(input);
                }
            });
            currentSprints.add(sprintDataEntry, issueEntries);
        }
        return ServiceOutcomeImpl.ok(currentSprints);
    }

    private Map<Long, RapidIssueEntry> getMapOfIdToEntry(List<RapidIssueEntry> entries) {
        HashMap<Long, RapidIssueEntry> map = new HashMap<Long, RapidIssueEntry>();
        for (RapidIssueEntry entry : entries) {
            map.put(entry.id, entry);
        }
        return map;
    }

    private List<PlanningDataModel.ProgressIndicator> getProgressIndicators(List<RapidIssueEntry> issueEntries, Map<Long, ColumnProgress> progressStatuses, I18n2 i18n) {
        PlanningDataModel.ProgressIndicator notStarted = PlanningDataModel.ProgressIndicator.from(ColumnProgress.NOT_STARTED, i18n);
        PlanningDataModel.ProgressIndicator inProgress = PlanningDataModel.ProgressIndicator.from(ColumnProgress.IN_PROGRESS, i18n);
        PlanningDataModel.ProgressIndicator done = PlanningDataModel.ProgressIndicator.from(ColumnProgress.DONE, i18n);
        double notStartedTotal = 0.0;
        double inProgressTotal = 0.0;
        double doneTotal = 0.0;
        for (RapidIssueEntry issueEntry : issueEntries) {
            ColumnProgress columnProgress = progressStatuses.get(issueEntry.getIssueId());
            if (columnProgress == null) continue;
            double statValue = 0.0;
            if (issueEntry.getEstimateStatistic() != null && issueEntry.getEstimateStatistic().getStatFieldValue() != null && issueEntry.getEstimateStatistic().getStatFieldValue().getValue() != null) {
                statValue = issueEntry.getEstimateStatistic().getStatFieldValue().getValue();
            }
            switch (columnProgress) {
                case NOT_STARTED: {
                    notStartedTotal += statValue;
                    break;
                }
                case IN_PROGRESS: {
                    inProgressTotal += statValue;
                    break;
                }
                case DONE: {
                    doneTotal += statValue;
                }
            }
        }
        notStarted.total = new RapidIssueEntry.NumberFieldValue(notStartedTotal);
        inProgress.total = new RapidIssueEntry.NumberFieldValue(inProgressTotal);
        done.total = new RapidIssueEntry.NumberFieldValue(doneTotal);
        return CollectionBuilder.list((Object[])new PlanningDataModel.ProgressIndicator[]{notStarted, inProgress, done});
    }

    private ServiceOutcome<List<SprintPlanEntry>> convertToSprintEntries(ApplicationUser user, Set<Long> sprintIds) {
        ServiceOutcome<List<Sprint>> sprintsOutcome = this.convertToSprintObjects(sprintIds);
        if (!sprintsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(sprintsOutcome);
        }
        List<Sprint> result = sprintsOutcome.getValue();
        Iterator<Sprint> iterator = result.iterator();
        while (iterator.hasNext()) {
            Sprint sprint = iterator.next();
            if (sprint.getState() != Sprint.State.CLOSED) continue;
            iterator.remove();
        }
        Collections.sort(result, SprintUtils.SPRINT_BYDATE_COMPARATOR);
        return ServiceOutcomeImpl.ok(this.sprintEntryFactory.newPlanTransformer(user).apply(result));
    }

    private ServiceOutcome<List<Sprint>> convertToSprintObjects(Set<Long> sprintIds) {
        LinkedList<Sprint> sprints = new LinkedList<Sprint>();
        for (Long sprintId : sprintIds) {
            ServiceOutcome<Sprint> sprint = this.sprintManager.getSprint(sprintId);
            if (sprint.isValid()) {
                sprints.add(sprint.getValue());
                continue;
            }
            return ServiceOutcomeImpl.error(sprint);
        }
        return ServiceOutcomeImpl.ok(sprints);
    }
}

