/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintPlanEntry;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public interface PlanningModeService {
    @Nonnull
    public ServiceOutcome<Result> getBacklogIssuesAndSprintAssignment(ApplicationUser var1, RapidView var2, Set<Long> var3);

    @Nonnull
    public ServiceOutcome<Iterable<Issue>> getTopRankedIssueInSprint(ApplicationUser var1, RapidView var2, Set<Long> var3);

    @Nonnull
    public ServiceOutcome<CurrentSprints> getCurrentSprintsAndIssues(ApplicationUser var1, RapidView var2, Set<Long> var3);

    @Nonnull
    public ServiceOutcome<SprintPlanEntry> getCurrentSprintAndIssues(ApplicationUser var1, RapidView var2, Long var3, Set<Long> var4);

    public static class CurrentSprints {
        private final Map<SprintPlanEntry, List<RapidIssueEntry>> sprintsToIssues = new LinkedHashMap<SprintPlanEntry, List<RapidIssueEntry>>();

        public void add(SprintPlanEntry sprint, Iterable<RapidIssueEntry> issues) {
            this.sprintsToIssues.put(sprint, (List<RapidIssueEntry>)ImmutableList.copyOf(issues));
        }

        public Map<SprintPlanEntry, List<RapidIssueEntry>> getSprintsToIssues() {
            return this.sprintsToIssues;
        }
    }

    public static class Result {
        CollectIssuesResult issuesResult;
        Map<Long, List<Long>> sprintToIssues;
    }
}

