/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.project.ProjectHistoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.navigation.WebItemSection;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.epics.EpicData;
import com.atlassian.greenhopper.web.rapid.epics.EpicsHelper;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.plan.PlanningDataModel;
import com.atlassian.greenhopper.web.rapid.plan.PlanningModeHelper;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntry;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntryTransformer;
import com.atlassian.greenhopper.web.rapid.work.WorkResource;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="xboard/plan")
@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PlanningModeResource
extends AbstractResource {
    private RapidViewService rapidViewService;
    private I18nFactoryService i18nFactoryService;
    private IssueService issueService;
    private ProjectHistoryService projectHistoryService;
    private ProjectEntryTransformer projectEntryTransformer;
    private PlanningModeHelper planningModeHelper;
    private SprintService sprintService;
    private final EpicsHelper epicsHelper;

    public PlanningModeResource(RapidViewService rapidViewService, I18nFactoryService i18nFactoryService, IssueService issueService, ProjectHistoryService projectHistoryService, ProjectEntryTransformer projectEntryTransformer, PlanningModeHelper planningModeHelper, SprintService sprintService, EpicsHelper epicsHelper) {
        this.rapidViewService = rapidViewService;
        this.i18nFactoryService = i18nFactoryService;
        this.issueService = issueService;
        this.projectHistoryService = projectHistoryService;
        this.projectEntryTransformer = projectEntryTransformer;
        this.planningModeHelper = planningModeHelper;
        this.sprintService = sprintService;
        this.epicsHelper = epicsHelper;
    }

    @GET
    @Path(value="/backlog/data")
    public Response getBacklogData(@QueryParam(value="rapidViewId") Long rapidViewId, @QueryParam(value="activeQuickFilters") Set<Long> activeQuickFilters, @QueryParam(value="selectedProjectKey") String selectedProjectKey) {
        return this.response(() -> {
            ApplicationUser user = this.getUser();
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, rapidViewId));
            this.log.debug("Loaded RapidView[id=%d]", rapidView.getId());
            PlanningDataModel dataModel = rapidView.isSprintSupportEnabled() ? this.check(this.planningModeHelper.loadNewBacklogData(user, rapidView, activeQuickFilters != null ? activeQuickFilters : new HashSet())) : this.check(this.planningModeHelper.loadKanbanBacklogData(user, rapidView, activeQuickFilters != null ? activeQuickFilters : new HashSet()));
            if (!this.isGadgetRequest()) {
                this.registerRecentProjects(user, rapidView, dataModel.projects, selectedProjectKey);
            }
            return this.createOkResponse(dataModel);
        });
    }

    @GET
    @Path(value="/backlog/epics")
    public Response getBacklogEpics(final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = PlanningModeResource.this.getUser();
                RapidView rapidView = PlanningModeResource.this.check(PlanningModeResource.this.rapidViewService.getRapidView(user, rapidViewId));
                EpicData epicData = PlanningModeResource.this.check(PlanningModeResource.this.epicsHelper.loadEpicData(user, rapidView));
                return PlanningModeResource.this.createOkResponse(epicData);
            }
        });
    }

    @GET
    @Path(value="/backlog/versions")
    public Response getBacklogVersions(final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = PlanningModeResource.this.getUser();
                RapidView rapidView = PlanningModeResource.this.check(PlanningModeResource.this.rapidViewService.getRapidView(user, rapidViewId));
                PlanningDataModel planningData = PlanningModeResource.this.check(PlanningModeResource.this.planningModeHelper.getBacklogVersions(user, rapidView));
                return PlanningModeResource.this.createOkResponse(planningData);
            }
        });
    }

    @GET
    @Path(value="/backlog/issue")
    public Response getBacklogIssue(@QueryParam(value="rapidViewId") Long rapidViewId, @QueryParam(value="issueId") Long issueId, @QueryParam(value="activeQuickFilters") Set<Long> activeQuickFilters) {
        return this.response(() -> {
            ApplicationUser user = this.getUser();
            IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
            this.check(ErrorCollection.fromJiraErrorCollection(result.getErrorCollection()));
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, rapidViewId));
            CollectIssuesResult collectResult = this.check(this.planningModeHelper.getBacklogIssue(user, rapidView, (Issue)result.getIssue(), activeQuickFilters != null ? activeQuickFilters : ImmutableSet.of()));
            return this.createOkResponse(new WorkResource.GetIssueResponse(collectResult));
        });
    }

    @GET
    @Path(value="/sprints/actions")
    public Response getSprintActions(@QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="sprintId") Long sprintId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = PlanningModeResource.this.getUser();
                Sprint sprint = PlanningModeResource.this.check(PlanningModeResource.this.sprintService.getSprint(user, sprintId));
                SprintActionsResponse response = new SprintActionsResponse();
                response.id = sprintId;
                response.sections = Lists.newArrayList(PlanningModeResource.this.planningModeHelper.getSprintActions(user, sprint));
                return PlanningModeResource.this.createOkResponse(response);
            }
        });
    }

    private void registerRecentProjects(ApplicationUser user, RapidView rapidView, List<ProjectEntry> projectEntries, String selectedProjectKey) {
        ArrayList projectsToRegister = Lists.newArrayList((Iterable)Iterables.transform(projectEntries, (Function)this.projectEntryTransformer));
        this.projectHistoryService.registerRecentProjects(user, rapidView, projectsToRegister, selectedProjectKey);
    }

    private void check(ErrorCollection errors) {
        if (errors.hasErrors()) {
            ErrorCollections.checkErrors(errors, this.i18nFactoryService.getI18n(this.getUser()));
        }
    }

    @XmlRootElement
    public static class SprintActionsResponse
    extends RestTemplate {
        @XmlElement
        private Long id;
        @XmlElement
        private List<WebItemSection> sections;
    }
}

