/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.plugin.DevStatusPluginMetadataService;
import com.atlassian.greenhopper.project.version.VersionMetaData;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.service.rapid.RecentSprintHistoryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.service.version.VersionPermissionService;
import com.atlassian.greenhopper.service.version.VersionService;
import com.atlassian.greenhopper.web.navigation.WebItemSection;
import com.atlassian.greenhopper.web.navigation.WebSectionHelper;
import com.atlassian.greenhopper.web.rapid.entity.epic.EpicLinkedPagesModelFactory;
import com.atlassian.greenhopper.web.rapid.entity.sprint.SprintLinkedPagesModelFactory;
import com.atlassian.greenhopper.web.rapid.epics.EpicsHelper;
import com.atlassian.greenhopper.web.rapid.list.ClassificationStatistics;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.plan.ClassificationStatisticService;
import com.atlassian.greenhopper.web.rapid.plan.KanbanPlanningDataModel;
import com.atlassian.greenhopper.web.rapid.plan.PlanModeVersionModel;
import com.atlassian.greenhopper.web.rapid.plan.PlanningDataModel;
import com.atlassian.greenhopper.web.rapid.plan.PlanningModeService;
import com.atlassian.greenhopper.web.rapid.plan.RankCustomFieldProvider;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntry;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntryTransformer;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintPlanEntry;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlanningModeHelper {
    @Autowired
    private PlanningModeService planningModeService;
    @Autowired
    private ProjectEntryTransformer projectEntryTransformer;
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private ClassificationStatisticService classificationStatisticService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private QueryService queryService;
    @Autowired
    private VersionService versionService;
    @Autowired
    private VersionManager versionManager;
    @Autowired
    private DateTimeFormatter dateTimeFormatterFactory;
    @Autowired
    private VersionPermissionService versionPermissionService;
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private SprintEntryFactory sprintEntryFactory;
    @Autowired
    private SprintPermissionService sprintPermissionService;
    @Autowired
    private SprintLinkedPagesModelFactory sprintLinkedPagesModelFactory;
    @Autowired
    private EpicLinkedPagesModelFactory epicLinkedPagesModelFactory;
    @Autowired
    private RecentSprintHistoryService recentSprintHistoryService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private WebSectionHelper webSectionHelper;
    @Autowired
    private DevStatusPluginMetadataService devStatusPluginMetadataService;
    @Autowired
    EpicsHelper epicsHelper;
    @Autowired
    RankCustomFieldProvider rankCustomFieldProvider;
    @Autowired
    ArchivingLicenseCheck archivingLicenseCheck;

    public ServiceOutcome<PlanningDataModel> loadNewBacklogData(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters) {
        ServiceOutcome<PlanningModeService.Result> issuesAndSprints = this.planningModeService.getBacklogIssuesAndSprintAssignment(user, rapidView, activeQuickFilters);
        if (issuesAndSprints.isInvalid()) {
            return ServiceOutcomeImpl.error(issuesAndSprints);
        }
        ServiceOutcome<List<SprintPlanEntry>> sprintsOutcome = this.buildSprints(user, rapidView, issuesAndSprints.get());
        if (sprintsOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintsOutcome);
        }
        CollectIssuesResult issuesResult = issuesAndSprints.get().issuesResult;
        ServiceOutcome<Collection<Project>> projectsOutcome = this.getProjects(user, rapidView, issuesResult::getProjects);
        if (!projectsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(projectsOutcome);
        }
        Collection<Project> projects = projectsOutcome.get();
        PlanningDataModel.VersionData versionData = this.loadVersionDataForProjects(user, projects, this::mapNameAndIdOnly);
        PlanningDataModel planDataModel = new PlanningDataModel();
        planDataModel.issues = issuesResult.getIssues();
        planDataModel.sprints = sprintsOutcome.getValue();
        planDataModel.versionData = versionData;
        planDataModel.projects = this.toProjectEntry(projects);
        planDataModel.entityData = issuesResult.getEntityData();
        planDataModel.rankCustomFieldId = this.rankCustomFieldProvider.getRankCustomFieldId(user, rapidView);
        planDataModel.canManageSprints = this.sprintPermissionService.hasManageSprintsPermission(user, rapidView);
        planDataModel.supportsPages = this.sprintLinkedPagesModelFactory.hasPagesSupport();
        planDataModel.canCreateIssue = !Collections.disjoint(this.permissionService.createIssueProjects(user), projects);
        planDataModel.hasBulkChangePermission = this.permissionService.hasGlobalPermission(user, GlobalPermissionKey.BULK_CHANGE);
        planDataModel.emptyFilterBoard = issuesAndSprints.get().issuesResult.isEmptyFilterBoard();
        planDataModel.cardColorStrategy = rapidView.getCardColorStrategy().getId();
        planDataModel.issueArchivingEnabled = this.isIssueArchivingEnabled();
        return ServiceOutcomeImpl.ok(planDataModel);
    }

    public ServiceOutcome<PlanningDataModel> loadKanbanBacklogData(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters) {
        ServiceOutcome<CollectIssuesResult> collectIssuesResultOutcome = this.rapidIssueEntryQueryService.collectKanbanPlanModeIssues(user, rapidView, activeQuickFilters);
        if (collectIssuesResultOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(collectIssuesResultOutcome);
        }
        CollectIssuesResult collectIssuesResult = collectIssuesResultOutcome.get();
        ServiceOutcome<Collection<Project>> projectsOutcome = this.getProjects(user, rapidView, collectIssuesResult::getProjects);
        if (!projectsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(projectsOutcome);
        }
        Collection<Project> projects = projectsOutcome.get();
        ServiceOutcome<CollectIssuesResult> missingParents = this.rapidIssueEntryQueryService.getMissingOrHiddenParents(user, rapidView, collectIssuesResultOutcome.get().getIssues(), CardLayoutField.Mode.PLAN);
        if (!missingParents.isValid()) {
            return ServiceOutcomeImpl.error(missingParents);
        }
        List<Column> mappedColumns = this.columnService.getValidColumns(rapidView);
        Column backlogColumn = mappedColumns.get(0);
        Preconditions.checkState((boolean)KanbanBacklogColumn.isKanbanBacklogColumn(backlogColumn));
        Column selectForDevColumn = mappedColumns.size() > 1 ? mappedColumns.get(1) : null;
        KanbanPlanningDataModel planningDataModel = new KanbanPlanningDataModel();
        planningDataModel.issues = collectIssuesResult.getIssues();
        planningDataModel.entityData = collectIssuesResult.getEntityData();
        planningDataModel.projects = this.toProjectEntry(projects);
        planningDataModel.sprints = Collections.emptyList();
        planningDataModel.backlogColumn = KanbanPlanningDataModel.ColumnEntry.toColumnEntry(this.jiraAuthenticationContext.getI18nHelper(), backlogColumn);
        planningDataModel.selectedForDevelopmentColumn = selectForDevColumn != null ? KanbanPlanningDataModel.ColumnEntry.toColumnEntry(this.jiraAuthenticationContext.getI18nHelper(), selectForDevColumn) : null;
        planningDataModel.missingParents = ImmutableSet.copyOf(missingParents.get().getIssues());
        planningDataModel.versionData = this.loadVersionDataForProjects(user, projects, this::mapNameAndIdOnly);
        planningDataModel.rankCustomFieldId = this.rankCustomFieldProvider.getRankCustomFieldId(user, rapidView);
        planningDataModel.canManageSprints = false;
        planningDataModel.supportsPages = this.epicLinkedPagesModelFactory.hasPagesSupport();
        planningDataModel.canCreateIssue = !Collections.disjoint(this.permissionService.createIssueProjects(user), projects);
        planningDataModel.hasBulkChangePermission = this.permissionService.hasGlobalPermission(user, GlobalPermissionKey.BULK_CHANGE);
        planningDataModel.emptyFilterBoard = collectIssuesResult.isEmptyFilterBoard();
        planningDataModel.cardColorStrategy = rapidView.getCardColorStrategy().getId();
        planningDataModel.issueArchivingEnabled = this.isIssueArchivingEnabled();
        return ServiceOutcomeImpl.ok(planningDataModel);
    }

    private ServiceOutcome<List<SprintPlanEntry>> buildSprints(ApplicationUser user, RapidView rapidView, PlanningModeService.Result result) {
        Map<Long, List<Long>> sprintToIssues = result.sprintToIssues;
        Collection<Sprint> sprintsWithIssues = SprintUtils.getSprintsForIds(this.sprintManager, sprintToIssues.keySet());
        EnumSet<Sprint.State> states = EnumSet.of(Sprint.State.ACTIVE, Sprint.State.FUTURE);
        ServiceOutcome<Collection<Sprint>> boardOwnedSprints = this.sprintManager.getSprintsForView(rapidView.getId(), states);
        if (boardOwnedSprints.isInvalid()) {
            return ServiceOutcomeImpl.error(boardOwnedSprints);
        }
        List<Sprint> sprints = SprintUtils.getFilteredAndSortedSprints(states, sprintsWithIssues, boardOwnedSprints.getValue());
        sprints.forEach(sprint -> this.recentSprintHistoryService.storeSprint(user, (Sprint)sprint));
        List sprintEntries = this.sprintEntryFactory.newPlanTransformer(user).apply(sprints);
        for (SprintPlanEntry sprintEntry : sprintEntries) {
            sprintEntry.issuesIds = sprintToIssues.getOrDefault(sprintEntry.id, Collections.emptyList());
        }
        return ServiceOutcomeImpl.ok(sprintEntries);
    }

    public ServiceOutcome<CollectIssuesResult> getBacklogIssue(ApplicationUser user, RapidView rapidView, Issue issue, Set<Long> activeQuickFilters) {
        ServiceOutcome<CollectIssuesResult> outcome = this.rapidIssueEntryQueryService.getIssuesById(user, rapidView, (Set<Long>)ImmutableSet.of((Object)issue.getId()), false, CardLayoutField.Mode.PLAN, activeQuickFilters);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        RapidIssueEntry entry = (RapidIssueEntry)Iterables.getOnlyElement(outcome.get().getIssues());
        ServiceOutcome<Void> trackingStatisticOutcome = this.rapidIssueEntryQueryService.loadBacklogTrackingStatisticValues(user, rapidView, entry);
        if (!trackingStatisticOutcome.isValid()) {
            return ServiceOutcomeImpl.error(trackingStatisticOutcome);
        }
        return outcome;
    }

    public ServiceOutcome<PlanningDataModel> getBacklogVersions(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Collection<Project>> projectsOutcome = this.getProjects(user, rapidView, () -> this.rapidIssueEntryQueryService.collectBacklogIssues(user, rapidView, Collections.emptySet()).getValue().getProjects());
        if (!projectsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(projectsOutcome);
        }
        ServiceOutcome<PlanningDataModel.VersionData> versionDataServiceOutcome = this.loadVersionDataForProjectsIncludingClassificationStatistics(user, rapidView, projectsOutcome.get());
        if (!versionDataServiceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(versionDataServiceOutcome);
        }
        PlanningDataModel model = new PlanningDataModel();
        model.versionData = versionDataServiceOutcome.getValue();
        model.projects = this.toProjectEntry(projectsOutcome.get());
        return ServiceOutcomeImpl.ok(model);
    }

    public Collection<WebItemSection> getSprintActions(ApplicationUser user, Sprint sprint) {
        Map contextParams = MapBuilder.newBuilder().add((Object)"sprint", (Object)sprint).add((Object)"sprintId", (Object)sprint.getId()).toMap();
        return this.webSectionHelper.getWebItemSections(user, "gh.plan.sprint.actions", contextParams);
    }

    private List<ProjectEntry> toProjectEntry(Collection<Project> projects) {
        ArrayList<ProjectEntry> entries = new ArrayList<ProjectEntry>();
        for (Project project : projects) {
            ProjectEntry entry = new ProjectEntry();
            entry.id = project.getId();
            entry.key = project.getKey();
            entry.name = project.getName();
            entries.add(entry);
        }
        return entries;
    }

    private ServiceOutcome<Collection<Project>> getProjects(ApplicationUser user, RapidView rapidView, Supplier<List<ProjectEntry>> projectSupplier) {
        ServiceOutcome<Set<Project>> projectsForRapidView = this.queryService.getProjectsForRapidViewFilterQuery(user, rapidView);
        if (!projectsForRapidView.isValid()) {
            return ServiceOutcomeImpl.error(projectsForRapidView);
        }
        Set<Project> projects = projectsForRapidView.get();
        if (!projects.isEmpty()) {
            return ServiceOutcomeImpl.ok(projects);
        }
        ImmutableList transform = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)projectSupplier.get(), (Function)this.projectEntryTransformer));
        return ServiceOutcomeImpl.ok(transform);
    }

    private PlanningDataModel.VersionData loadVersionDataForProjects(ApplicationUser user, Collection<Project> projects, java.util.function.Function<Version, PlanModeVersionModel> versionToVersionModelMapper) {
        Map versionModelsPerProject = projects.stream().flatMap(project -> this.versionManager.getVersions(project.getId(), false).stream()).collect(Collectors.groupingBy(Version::getProjectId, Collectors.mapping(versionToVersionModelMapper, Collectors.toList())));
        PlanningDataModel.VersionData data = new PlanningDataModel.VersionData();
        data.versionsPerProject = versionModelsPerProject;
        ServiceOutcome<Void> canCreateVersion = this.versionPermissionService.canCreateAnyVersion(user, projects);
        data.canCreateVersion = canCreateVersion.isValid();
        data.isLinkToDevStatusVersionAvailable = this.devStatusPluginMetadataService.isReleaseReportSupported();
        return data;
    }

    private PlanModeVersionModel mapNameAndIdOnly(Version version) {
        PlanModeVersionModel planModeVersionModel = new PlanModeVersionModel();
        planModeVersionModel.name = version.getName();
        planModeVersionModel.id = version.getId();
        return planModeVersionModel;
    }

    private ServiceOutcome<PlanningDataModel.VersionData> loadVersionDataForProjectsIncludingClassificationStatistics(ApplicationUser user, RapidView rapidView, Collection<Project> projects) {
        ServiceOutcome<Map<String, ClassificationStatistics>> versionStatisticsOutcome = this.classificationStatisticService.getVersionStatistics(user, rapidView);
        if (!versionStatisticsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(versionStatisticsOutcome);
        }
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.forUser(user).withDefaultZone().withStyle(DateTimeStyle.DATE_PICKER);
        return ServiceOutcomeImpl.ok(this.loadVersionDataForProjects(user, projects, version -> {
            ClassificationStatistics classificationStatistics;
            Date startDate;
            VersionMetaData versionMetaData = this.versionService.getMetaData((Version)version);
            PlanModeVersionModel planModeVersionModel = new PlanModeVersionModel();
            planModeVersionModel.id = version.getId();
            planModeVersionModel.name = version.getName();
            planModeVersionModel.description = version.getDescription();
            planModeVersionModel.sequence = version.getSequence();
            planModeVersionModel.released = version.isReleased();
            Date releaseDate = version.getReleaseDate();
            if (releaseDate != null) {
                planModeVersionModel.releaseDate = releaseDate;
                planModeVersionModel.releaseDateFormatted = dateTimeFormatter.format(releaseDate);
            }
            if ((startDate = versionMetaData.getStartDate()) != null) {
                planModeVersionModel.startDate = startDate;
                planModeVersionModel.startDateFormatted = dateTimeFormatter.format(startDate);
            }
            planModeVersionModel.versionStats = (classificationStatistics = (ClassificationStatistics)((Map)versionStatisticsOutcome.get()).get(String.valueOf(planModeVersionModel.id))) == null ? new ClassificationStatistics() : classificationStatistics;
            return planModeVersionModel;
        }));
    }

    private boolean isIssueArchivingEnabled() {
        return this.archivingLicenseCheck.isLicensedForIssueArchiving();
    }
}

