/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.util.ServiceOutcomeException;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.plan.IssueTransitionDataService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueTransitionDataServiceImpl
implements IssueTransitionDataService {
    @Autowired
    protected JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    protected RapidViewService rapidViewService;
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;

    @Override
    public Set<RapidIssueEntry> getIssueData(Set<Long> issueIds, IssueTransitionAndRankService.TransitionAndRankRequest request) throws ServiceOutcomeException {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getLoggedInUser();
        RapidView rapidView = ServiceOutcomeHelper.get(this.rapidViewService.getRapidView(currentUser, request.getRapidViewId()));
        return new HashSet<RapidIssueEntry>(this.rapidIssueEntryQueryService.getIssuesById(currentUser, rapidView, issueIds, false, CardLayoutField.Mode.PLAN, request.getActiveQuickFilters()).get().getIssues());
    }
}

