/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.MappedStatusIds;
import com.atlassian.greenhopper.service.rapid.RapidViewColumnService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.web.rapid.issue.StatisticFieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.StatisticValueResolverFactory;
import com.atlassian.greenhopper.web.rapid.list.ClassificationStatistics;
import com.atlassian.greenhopper.web.rapid.plan.ClassificationStatisticCallback;
import com.atlassian.greenhopper.web.rapid.plan.ClassificationStatisticService;
import com.atlassian.greenhopper.web.rapid.plan.EpicStatisticCallback;
import com.atlassian.greenhopper.web.rapid.plan.VersionStatisticCallback;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClassificationStatisticServiceImpl
implements ClassificationStatisticService {
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private RapidViewColumnService rapidViewColumnService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private StatisticValueResolverFactory statisticValueResolverFactory;
    @Autowired
    private StatisticFieldHelper statisticFieldHelper;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private StatisticsFieldService statisticsFieldService;

    @Override
    public ServiceOutcome<Map<String, ClassificationStatistics>> getEpicStatistics(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<MappedStatusIds> mappedStatusIdsOutcome = this.rapidViewColumnService.getMappedStatusIds(user, rapidView);
        if (mappedStatusIdsOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(mappedStatusIdsOutcome);
        }
        ServiceOutcome<DocumentStatisticValueResolver> documentStatisticValueResolverOutcome = this.getDocumentStatisticValueResolver(rapidView);
        if (documentStatisticValueResolverOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(documentStatisticValueResolverOutcome);
        }
        CustomField linkField = this.epicCustomFieldService.getDefaultEpicLinkField();
        EpicStatisticCallback epicStatisticCallback = new EpicStatisticCallback(linkField, documentStatisticValueResolverOutcome.getValue(), this.statisticFieldHelper, mappedStatusIdsOutcome.getValue());
        return this.getClassificationStatistics(user, rapidView, epicStatisticCallback);
    }

    @Override
    public ServiceOutcome<Map<String, ClassificationStatistics>> getVersionStatistics(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<MappedStatusIds> mappedStatusIds = this.rapidViewColumnService.getMappedStatusIds(user, rapidView);
        if (mappedStatusIds.isInvalid()) {
            return ServiceOutcomeImpl.error(mappedStatusIds);
        }
        ServiceOutcome<DocumentStatisticValueResolver> documentStatisticValueResolverOutcome = this.getDocumentStatisticValueResolver(rapidView);
        if (documentStatisticValueResolverOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(documentStatisticValueResolverOutcome);
        }
        VersionStatisticCallback versionStatisticCallback = new VersionStatisticCallback(documentStatisticValueResolverOutcome.getValue(), this.statisticFieldHelper, mappedStatusIds.getValue());
        return this.getClassificationStatistics(user, rapidView, versionStatisticCallback);
    }

    private ServiceOutcome<Map<String, ClassificationStatistics>> getClassificationStatistics(ApplicationUser user, RapidView rapidView, ClassificationStatisticCallback classificationStatisticCallback) {
        Query query;
        ServiceOutcome<Void> searchOutcome;
        boolean shouldCountOnlyIssues;
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (rapidViewQuery.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        JqlClauseBuilder clauseBuilder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where();
        ServiceOutcome<StatisticsFieldConfig> statisticsField = this.statisticsFieldService.loadStatisticsField(rapidView);
        boolean bl = shouldCountOnlyIssues = rapidView.getType().equals((Object)RapidView.Type.KANBAN) && statisticsField.isValid() && statisticsField.get().getType().equals((Object)StatisticsFieldConfig.Type.ISSUE_COUNT_EXCL_SUBS) || rapidView.getType().equals((Object)RapidView.Type.SCRUM);
        if (shouldCountOnlyIssues) {
            clauseBuilder.defaultAnd().issueTypeIsStandard();
        }
        if ((searchOutcome = this.issueDataService.findWithServiceOutcome(user, query = clauseBuilder.buildQuery(), classificationStatisticCallback)).isInvalid()) {
            return ServiceOutcomeImpl.error(searchOutcome);
        }
        return ServiceOutcomeImpl.ok(classificationStatisticCallback.getClassificationStatistics());
    }

    private ServiceOutcome<DocumentStatisticValueResolver> getDocumentStatisticValueResolver(RapidView rapidView) {
        ServiceOutcome<StatisticsField> estimateStatisticStrict = this.estimateStatisticService.getEstimateStatisticStrict(rapidView);
        if (estimateStatisticStrict.isInvalid()) {
            return ServiceOutcomeImpl.error(estimateStatisticStrict);
        }
        StatisticsField statisticsField = estimateStatisticStrict.getValue();
        DocumentStatisticValueResolver documentStatisticValueResolver = this.statisticValueResolverFactory.forEstimationStatisticInDocument(statisticsField);
        return ServiceOutcomeImpl.ok(documentStatisticValueResolver);
    }
}

