/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.service.rapid.MappedStatusIds;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.greenhopper.web.rapid.issue.StatisticFieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.list.ClassificationStatistics;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ClassificationStatisticCallback
extends AbstractCompoundDataCallback {
    private final DocumentStatisticValueResolver documentStatisticValueResolver;
    private final String statisticFieldDocumentId;
    private final StatisticFieldHelper statisticsFieldHelper;
    Map<String, ClassificationStatistics> statsData;
    private final MappedStatusIds statusIds;
    private Map<String, Boolean> statusIsInDoneColumn;

    public ClassificationStatisticCallback(DocumentStatisticValueResolver documentStatisticValueResolver, StatisticFieldHelper statisticsFieldHelper, MappedStatusIds statusIds) {
        this.statusIds = statusIds;
        this.statisticsFieldHelper = statisticsFieldHelper;
        this.documentStatisticValueResolver = documentStatisticValueResolver;
        this.statisticFieldDocumentId = documentStatisticValueResolver.getDocumentId();
        this.statsData = new HashMap<String, ClassificationStatistics>();
        this.statusIsInDoneColumn = new HashMap<String, Boolean>();
        for (String status : statusIds.getDoneStatusIds()) {
            this.statusIsInDoneColumn.put(status, true);
        }
        for (String status : statusIds.getNotDoneStatusIds()) {
            this.statusIsInDoneColumn.put(status, false);
        }
    }

    @Override
    public Set<String> getFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add(this.getClassificationIdField());
        fields.add(this.statisticFieldDocumentId);
        fields.add("status");
        fields.add("projid");
        fields.add("type");
        return fields;
    }

    public abstract String getClassificationIdField();

    public abstract boolean doesIssueHaveClassificationId(IssueFieldValueProvider var1);

    @Override
    protected void fieldData(Long issueId, String issueKey, IssueFieldValueProvider data) {
        if (!this.doesIssueHaveClassificationId(data)) {
            return;
        }
        String status = data.get("status");
        Long projectId = NumberUtils.toLong(data.get("projid"));
        String issueType = data.get("type");
        String estimate = data.get(this.statisticFieldDocumentId);
        List<String> classificationIds = data.getList(this.getClassificationIdField());
        if (projectId == null) {
            return;
        }
        Boolean done = this.statusIsInDoneColumn.get(status);
        if (done == null) {
            return;
        }
        for (String id : classificationIds) {
            RapidIssueEntry.StatisticFieldValue estimateStatisticField;
            this.statsData.putIfAbsent(id, new ClassificationStatistics());
            ClassificationStatistics stats = this.statsData.get(id);
            if (done.booleanValue()) {
                ++stats.done;
            } else {
                ++stats.notDone;
            }
            if ((estimateStatisticField = this.statisticsFieldHelper.createEstimateStatistic(projectId, issueType, estimate, this.documentStatisticValueResolver)) == null) continue;
            Double estimateValue = estimateStatisticField.getStatFieldValue().getValue();
            if (estimateValue != null) {
                ++stats.estimated;
                if (done.booleanValue()) {
                    stats.doneEstimate += estimateValue.doubleValue();
                    continue;
                }
                stats.notDoneEstimate += estimateValue.doubleValue();
                continue;
            }
            if (done.booleanValue()) continue;
            ++stats.notEstimated;
        }
    }

    public Map<String, ClassificationStatistics> getClassificationStatistics() {
        for (ClassificationStatistics stats : this.statsData.values()) {
            this.calculateTotalsAndPercentages(stats);
        }
        return this.statsData;
    }

    private void calculateTotalsAndPercentages(ClassificationStatistics stats) {
        stats.totalIssueCount = stats.notDone + stats.done;
        int estimatedNotEstimatedSum = stats.estimated + stats.notEstimated;
        stats.percentageEstimated = estimatedNotEstimatedSum != 0 ? Math.floor(100 * stats.estimated / estimatedNotEstimatedSum) : 0.0;
        stats.percentageUnestimated = 100.0 - stats.percentageEstimated;
        stats.totalEstimate = stats.notDoneEstimate + stats.doneEstimate;
        stats.percentageCompleted = stats.totalEstimate != 0.0 ? Math.floor(100.0 * stats.doneEstimate / stats.totalEstimate) : 0.0;
    }
}

