/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.plan;

import com.atlassian.greenhopper.web.CurrentRequestGetter;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkChangeIssuesAction
extends GreenHopperWebActionSupport {
    private String issueKeys;
    @Autowired
    private CurrentRequestGetter currentRequestGetter;
    @Autowired
    private IssueFinder issueFinder;
    @Autowired
    private BulkEditBeanFactory bulkEditBeanFactory;

    protected String doExecute() throws Exception {
        HttpSession session = this.currentRequestGetter.getCurrentSession();
        if (session != null) {
            this.setSearchRequestInSession(session);
            this.setBulkEditConfigInSession(session);
        }
        return this.getRedirect("BulkChooseOperation!default.jspa");
    }

    private void setSearchRequestInSession(HttpSession session) {
        session.setAttribute("jira.issue.navigator.search.request", (Object)this.createSearchRequest());
    }

    private void setBulkEditConfigInSession(HttpSession session) {
        List<Issue> issues = this.getIssues();
        BulkEditBean bulkEditBean = this.bulkEditBeanFactory.createBulkEditBean();
        bulkEditBean.initSelectedIssues(issues);
        bulkEditBean.setIssuesFromSearchRequest(issues);
        session.setAttribute("jira.bulkeditbean", (Object)bulkEditBean);
    }

    private List<Issue> getIssues() {
        ArrayList issues = Lists.newArrayList();
        if (this.getIssueKeys() == null) {
            return issues;
        }
        SimpleErrorCollection errors = new SimpleErrorCollection();
        for (String issueKey : this.getIssueKeys().split(",")) {
            Issue issue = this.issueFinder.findIssue(issueKey, (ErrorCollection)errors);
            if (errors.hasAnyErrors()) continue;
            issues.add(issue);
        }
        return issues;
    }

    private SearchRequest createSearchRequest() {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        String[] inIssueKeys = this.issueKeys != null ? this.issueKeys.split(",") : new String[]{};
        return new SearchRequest(builder.where().issue(inIssueKeys).buildQuery());
    }

    public String getIssueKeys() {
        return this.issueKeys;
    }

    public void setIssueKeys(String issueKeys) {
        this.issueKeys = issueKeys;
    }
}

