/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.features.JiraSoftwareFeature;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.FlagCustomFieldProvider;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.query.QueryUtils;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.IssueStatusHistoryService;
import com.atlassian.greenhopper.service.configuration.JiraSoftwareFeatureService;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.issue.callback.AbstractColumnStatisticsCallback;
import com.atlassian.greenhopper.service.issue.callback.ColumnStatisticsCallbackFactory;
import com.atlassian.greenhopper.service.issue.callback.ComposedIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.FixVersionCallbackComponent;
import com.atlassian.greenhopper.service.issue.callback.FlaggingCallbackComponent;
import com.atlassian.greenhopper.service.issue.callback.IssueCountAndLastUpdatedCollector;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueIdNumericCollector;
import com.atlassian.greenhopper.service.issue.callback.ProjectIssueDataCallback;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.issuelink.EpicLinkClauseFactory;
import com.atlassian.greenhopper.service.rapid.EmptyFilterQueryWrapper;
import com.atlassian.greenhopper.service.rapid.EmptyQueryAwareJqlBuilder;
import com.atlassian.greenhopper.service.rapid.RapidViewClauseService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldService;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorPalette;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorQueryService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.service.user.GHAvatarService;
import com.atlassian.greenhopper.service.util.ServiceOutcomeException;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.util.jql.EpicsQueryHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatisticFieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.StatisticFieldAggregationCallback;
import com.atlassian.greenhopper.web.rapid.issue.statistics.StatisticValueResolverFactory;
import com.atlassian.greenhopper.web.rapid.list.AssigneeCallbackComponent;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesEvent;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.DaysInColumnCallback;
import com.atlassian.greenhopper.web.rapid.list.EpicCallbackComponent;
import com.atlassian.greenhopper.web.rapid.list.EpicMetadataCallbackComponent;
import com.atlassian.greenhopper.web.rapid.list.ExtraFieldsCallbackComponent;
import com.atlassian.greenhopper.web.rapid.list.ExtraFieldsContext;
import com.atlassian.greenhopper.web.rapid.list.ExtraFieldsHelper;
import com.atlassian.greenhopper.web.rapid.list.MoveIssuesEvent;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallback;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntry;
import com.atlassian.greenhopper.web.rapid.work.WorkFilters;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidIssueEntryQueryServiceImpl
implements RapidIssueEntryQueryService {
    @Autowired
    private IssueStatusHistoryService issueStatusHistoryService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private ConstantsManager constantsManager;
    @Autowired
    private GHAvatarService avatarService;
    @Autowired
    private AvatarService jiraAvatarService;
    @Autowired
    private WebUtilities webUtilities;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private StatisticFieldHelper statisticFieldHelper;
    @Autowired
    private StatisticValueResolverFactory statisticValueResolverFactory;
    @Autowired
    private CardColorQueryService cardColorQueryService;
    @Autowired
    private CardColorPalette cardColorPalette;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private ColumnStatisticsCallbackFactory columnStatisticsCallbackFactory;
    @Autowired
    private FlagCustomFieldProvider flagCustomFieldProvider;
    @Autowired
    private StatusEntryFactory statusEntryFactory;
    @Autowired
    private ExtraFieldsHelper extraFieldsHelper;
    @Autowired
    private CardLayoutFieldService cardLayoutFieldService;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private RapidViewClauseService rapidViewClauseService;
    @Autowired
    private EpicsQueryHelper epicsQueryHelper;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private JiraSoftwareFeatureService jiraSoftwareFeaturesService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private IssueManager issueManager;
    protected final LoggerWrapper performanceLogger = LoggerWrapper.with("com.atlassian.greenhopper.performance");

    @Override
    @Nonnull
    public ServiceOutcome<CollectIssuesResult> collectWorkModeIssues(ApplicationUser user, RapidView rapidView, WorkFilters workFilters) {
        ServiceOutcome<Query> queryOutcome = this.getWorkModeQuery(user, rapidView, workFilters);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        boolean loadDaysInColumn = this.isDaysInColumnGlobalEnabled() && rapidView.showDaysInColumn();
        boolean sorted = true;
        Predicate visiblePredicate = Predicates.alwaysTrue();
        boolean exactQueryMatch = false;
        long startCollectingTime = System.currentTimeMillis();
        ServiceOutcome<CollectIssuesResult> collectIssuesResult = this.collectIssues(user, rapidView, queryOutcome.get(), loadDaysInColumn, sorted, (Predicate<Long>)visiblePredicate, exactQueryMatch, ExtraFieldsContext.create(rapidView, CardLayoutField.Mode.WORK));
        this.publishCollectIssuesEvent(rapidView, CardLayoutField.Mode.WORK, collectIssuesResult.getValue(), System.currentTimeMillis() - startCollectingTime);
        return collectIssuesResult;
    }

    private ServiceOutcome<Query> getWorkModeQuery(ApplicationUser user, RapidView rapidView, WorkFilters workFilters) {
        ServiceOutcome<Query> queryOutcome = this.rapidViewQueryService.getWorkModeQuery(user, rapidView);
        if (queryOutcome.isInvalid()) {
            return queryOutcome;
        }
        JqlQueryBuilder builder = QueryUtils.addClauses(queryOutcome.getValue(), workFilters.getQuickFiltersClause(), workFilters.getSprintClause(), workFilters.getKanbanBacklogFilterClause(), workFilters.getKanbanDoneColumnFilterClause());
        return ServiceOutcomeImpl.ok(builder.buildQuery());
    }

    @Override
    @Nonnull
    public ServiceOutcome<CollectIssuesResult> collectBacklogIssues(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters) {
        boolean exactQueryMatch;
        boolean sorted;
        boolean loadDaysInColumn;
        ServiceOutcome<Query> backlogQueryOutcome = this.rapidViewQueryService.getBacklogQuery(user, rapidView);
        if (!backlogQueryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(backlogQueryOutcome);
        }
        ServiceOutcome<ClauseToAdd> quickFilterClause = this.rapidViewQueryService.getQuickFilterClause(user, rapidView, activeQuickFilters);
        if (!quickFilterClause.isValid()) {
            return ServiceOutcomeImpl.error(quickFilterClause);
        }
        JqlQueryBuilder visibleIssueQueryBuilder = QueryUtils.addClauses(backlogQueryOutcome.getValue(), quickFilterClause.getValue());
        ServiceOutcome<Predicate<Long>> predicateServiceOutcome = this.visiblePredicateForQuery(user, visibleIssueQueryBuilder.buildQuery());
        if (!predicateServiceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(predicateServiceOutcome);
        }
        Predicate<Long> visiblePredicate = predicateServiceOutcome.get();
        Query backlogQuery = backlogQueryOutcome.getValue();
        ServiceOutcome<CollectIssuesResult> collectIssuesResult = this.collectIssues(user, rapidView, backlogQuery, loadDaysInColumn = false, sorted = true, visiblePredicate, exactQueryMatch = false, ExtraFieldsContext.create(rapidView, CardLayoutField.Mode.PLAN));
        if (!collectIssuesResult.isValid()) {
            return ServiceOutcomeImpl.error(collectIssuesResult);
        }
        ServiceOutcome<Void> outcome = this.loadBacklogTrackingStatisticValues(user, rapidView, collectIssuesResult.getValue().getIssues());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return collectIssuesResult;
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> collectOpenSprintIssues(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters, IssueDataCallback additionalCallback) {
        ServiceOutcome<Query> activeSprintsQuery = this.rapidViewQueryService.getActiveSprintsForPlanModeQuery(user, rapidView);
        if (!activeSprintsQuery.isValid()) {
            return ServiceOutcomeImpl.error(activeSprintsQuery);
        }
        ServiceOutcome<ClauseToAdd> quickFilterClause = this.rapidViewQueryService.getQuickFilterClause(user, rapidView, activeQuickFilters);
        if (!quickFilterClause.isValid()) {
            return ServiceOutcomeImpl.error(quickFilterClause);
        }
        JqlQueryBuilder visibleIssueQuery = QueryUtils.addClauses(activeSprintsQuery.getValue(), quickFilterClause.getValue());
        ServiceOutcome<Predicate<Long>> predicateServiceOutcome = this.visiblePredicateForQuery(user, visibleIssueQuery.buildQuery());
        if (!predicateServiceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(predicateServiceOutcome);
        }
        Predicate<Long> visiblePredicate = predicateServiceOutcome.get();
        Query query = activeSprintsQuery.getValue();
        boolean loadDaysInColumn = false;
        boolean sorted = true;
        boolean exactQueryMatch = false;
        return this.collectIssues(user, rapidView, query, loadDaysInColumn, sorted, visiblePredicate, exactQueryMatch, additionalCallback, null, ExtraFieldsContext.create(rapidView, CardLayoutField.Mode.PLAN));
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> collectSprintIssues(ApplicationUser user, RapidView rapidView, Long sprintId, IssueDataCallback additionalCallback) {
        ServiceOutcome<Query> sprintQuery = this.rapidViewQueryService.getOpenSprintQuery(user, rapidView, sprintId);
        if (!sprintQuery.isValid()) {
            return ServiceOutcomeImpl.error(sprintQuery);
        }
        ServiceOutcome<Predicate<Long>> predicateServiceOutcome = this.visiblePredicateForQuery(user, sprintQuery.getValue());
        if (!predicateServiceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(predicateServiceOutcome);
        }
        Predicate<Long> visiblePredicate = predicateServiceOutcome.get();
        Query query = sprintQuery.getValue();
        boolean loadDaysInColumn = true;
        boolean sorted = true;
        boolean exactQueryMatch = false;
        return this.collectIssues(user, rapidView, query, loadDaysInColumn, sorted, visiblePredicate, exactQueryMatch, additionalCallback, null, ExtraFieldsContext.NONE);
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> collectPlanModeIssues(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters, IssueDataCallback additionalCallback) {
        ServiceOutcome<Predicate<Long>> predicateServiceOutcome;
        ServiceOutcome<Query> planModeIssuesQuery = this.rapidViewQueryService.getPlanModeIssuesQuery(user, rapidView);
        if (!planModeIssuesQuery.isValid()) {
            return ServiceOutcomeImpl.error(planModeIssuesQuery);
        }
        EmptyQueryAwareJqlBuilder jqlBuilder = EmptyQueryAwareJqlBuilder.newBuilder(planModeIssuesQuery.getValue());
        jqlBuilder.where().defaultAnd().issueTypeIsStandard();
        Query planModeIssuesQueryWithoutSubtasks = jqlBuilder.buildQuery();
        ServiceOutcome<ClauseToAdd> quickFilterClause = this.rapidViewQueryService.getQuickFilterClause(user, rapidView, activeQuickFilters);
        if (!quickFilterClause.isValid()) {
            return ServiceOutcomeImpl.error(quickFilterClause);
        }
        JqlQueryBuilder visibleIssueQuery = QueryUtils.addClauses(planModeIssuesQueryWithoutSubtasks, quickFilterClause.getValue());
        if (!(planModeIssuesQueryWithoutSubtasks instanceof EmptyFilterQueryWrapper)) {
            visibleIssueQuery.where().defaultAnd().issueTypeIsStandard();
        }
        if (!(predicateServiceOutcome = this.visiblePredicateForQuery(user, visibleIssueQuery.buildQuery())).isValid()) {
            return ServiceOutcomeImpl.error(predicateServiceOutcome);
        }
        Predicate<Long> visiblePredicate = predicateServiceOutcome.get();
        Query query = EmptyFilterQueryWrapper.wrap(planModeIssuesQuery.getValue(), planModeIssuesQueryWithoutSubtasks);
        boolean loadDaysInColumn = false;
        boolean sorted = true;
        boolean exactQueryMatch = false;
        long startCollectingTime = System.currentTimeMillis();
        ServiceOutcome<CollectIssuesResult> collectIssuesResult = this.collectIssues(user, rapidView, query, loadDaysInColumn, sorted, visiblePredicate, exactQueryMatch, additionalCallback, null, ExtraFieldsContext.create(rapidView, CardLayoutField.Mode.PLAN));
        if (!collectIssuesResult.isValid()) {
            return ServiceOutcomeImpl.error(collectIssuesResult);
        }
        this.publishCollectIssuesEvent(rapidView, CardLayoutField.Mode.PLAN, collectIssuesResult.getValue(), System.currentTimeMillis() - startCollectingTime);
        ServiceOutcome<Void> outcome = this.loadAggregateTrackingStatistic(user, rapidView, collectIssuesResult.getValue().getIssues(), planModeIssuesQuery.getValue());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return collectIssuesResult;
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> collectKanbanPlanModeIssues(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters) {
        return this.collectKanbanPlanModeIssues(user, rapidView, activeQuickFilters, true, ExtraFieldsContext.create(rapidView, CardLayoutField.Mode.PLAN));
    }

    private ServiceOutcome<CollectIssuesResult> collectKanbanPlanModeIssues(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters, boolean publishEvent, ExtraFieldsContext extraFieldsContext) {
        ServiceOutcome<Query> queryOutcome = this.rapidViewQueryService.getWorkModeQuery(user, rapidView);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        ServiceOutcome<ClauseToAdd> quickFilterClause = this.rapidViewQueryService.getQuickFilterClause(user, rapidView, activeQuickFilters);
        if (!quickFilterClause.isValid()) {
            return ServiceOutcomeImpl.error(quickFilterClause);
        }
        ServiceOutcome<ClauseToAdd> kanbanPlanModeClause = this.rapidViewClauseService.getKanbanPlanModeClause(user, rapidView);
        if (kanbanPlanModeClause.isInvalid()) {
            return ServiceOutcomeImpl.error(kanbanPlanModeClause);
        }
        JqlQueryBuilder visibleIssueQueryBuilder = QueryUtils.addClauses(queryOutcome.getValue(), quickFilterClause.getValue(), kanbanPlanModeClause.getValue());
        ServiceOutcome<Predicate<Long>> predicateServiceOutcome = this.visiblePredicateForQuery(user, visibleIssueQueryBuilder.buildQuery());
        if (!predicateServiceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(predicateServiceOutcome);
        }
        Predicate<Long> visiblePredicate = predicateServiceOutcome.get();
        JqlQueryBuilder allIssueQueryBuilder = QueryUtils.addClauses(queryOutcome.getValue(), kanbanPlanModeClause.getValue());
        Query query = EmptyFilterQueryWrapper.wrap(queryOutcome.getValue(), allIssueQueryBuilder.buildQuery());
        long startCollectingTime = System.currentTimeMillis();
        ServiceOutcome<CollectIssuesResult> collectIssuesResult = this.collectIssues(user, rapidView, query, false, true, visiblePredicate, false, extraFieldsContext);
        if (publishEvent) {
            this.publishCollectIssuesEvent(rapidView, CardLayoutField.Mode.PLAN, collectIssuesResult.getValue(), System.currentTimeMillis() - startCollectingTime);
        }
        return collectIssuesResult;
    }

    @Override
    public ServiceOutcome<List<String>> collectKanbanPlanModeIssueKeys(ApplicationUser user, RapidView rapidView, Set<Long> activeQuickFilters) {
        ServiceOutcome<CollectIssuesResult> collectIssuesResult = this.collectKanbanPlanModeIssues(user, rapidView, activeQuickFilters, false, ExtraFieldsContext.NONE);
        if (collectIssuesResult.isInvalid()) {
            return ServiceOutcomeImpl.from(collectIssuesResult.getErrors());
        }
        return ServiceOutcomeImpl.ok(collectIssuesResult.get().getIssues().stream().map(RapidIssueEntry::getIssueKey).collect(Collectors.toList()));
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> collectEpicIssues(ApplicationUser user, RapidView rapidView, Set<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return ServiceOutcomeImpl.ok(CollectIssuesResult.empty());
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        builder.where().issue().in(issueKeys.toArray(new String[issueKeys.size()])).endWhere().orderBy().issueKey(SortOrder.ASC);
        return this.collectEpicIssues(user, rapidView, builder);
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> collectEpicIssues(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<JqlQueryBuilder> epicsQueryOutcome = this.epicsQueryHelper.getEpicsQuery(user, rapidView);
        if (epicsQueryOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(epicsQueryOutcome);
        }
        return this.collectEpicIssues(user, rapidView, epicsQueryOutcome.getValue());
    }

    private ServiceOutcome<CollectIssuesResult> collectEpicIssues(ApplicationUser user, RapidView rapidView, JqlQueryBuilder backlogEpics) {
        CustomField epicLabelField = this.epicCustomFieldService.getDefaultEpicLabelField();
        CustomField epicColorField = this.epicCustomFieldService.getDefaultEpicColorField();
        CustomField epicStatusField = this.epicCustomFieldService.getDefaultEpicStatusField();
        EpicMetadataCallbackComponent epicMetadataCallbackComponent = this.createEpicMetadataCallbackComponent(epicLabelField, epicColorField, epicStatusField);
        Query epicsQuery = backlogEpics.buildQuery();
        boolean loadDaysInColumn = false;
        boolean sorted = true;
        Predicate visiblePredicate = Predicates.alwaysTrue();
        boolean exactQueryMatch = false;
        return this.collectIssues(user, rapidView, epicsQuery, loadDaysInColumn, sorted, (Predicate<Long>)visiblePredicate, exactQueryMatch, null, epicMetadataCallbackComponent, ExtraFieldsContext.NONE);
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> collectIssuesForEpic(ApplicationUser user, RapidView rapidView, String epicKey) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        Clause clause = EpicLinkClauseFactory.hasEpic(this.epicCustomFieldService.getDefaultEpicLinkField(), epicKey);
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where().defaultAnd().addClause(clause).endWhere();
        Query query = builder.buildQuery();
        boolean sorted = false;
        Predicate visiblePredicate = Predicates.alwaysTrue();
        boolean exactQueryMatch = true;
        boolean loadDaysInColumn = false;
        return this.collectIssues(user, rapidView, query, loadDaysInColumn, sorted, (Predicate<Long>)visiblePredicate, exactQueryMatch, ExtraFieldsContext.NONE);
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> collectIssuesForVersion(ApplicationUser user, RapidView rapidView, Version version) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        Query query = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where().defaultAnd().fixVersion(version.getId()).issueTypeIsStandard().buildQuery();
        boolean sorted = false;
        Predicate visiblePredicate = Predicates.alwaysTrue();
        boolean exactQueryMatch = true;
        boolean loadDaysInColumn = false;
        return this.collectIssues(user, rapidView, query, loadDaysInColumn, sorted, (Predicate<Long>)visiblePredicate, exactQueryMatch, ExtraFieldsContext.NONE);
    }

    @Override
    public ServiceOutcome<Set<Long>> collectBacklogProjects(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> backlogQueryOutcome = this.rapidViewQueryService.getBacklogQuery(user, rapidView);
        if (!backlogQueryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(backlogQueryOutcome);
        }
        ProjectIssueDataCallback projectIdsCallback = new ProjectIssueDataCallback();
        ServiceOutcome<Void> visibleIssuesOutcome = this.issueDataService.findWithServiceOutcome(user, backlogQueryOutcome.getValue(), projectIdsCallback);
        if (!visibleIssuesOutcome.isValid()) {
            return ServiceOutcomeImpl.error(visibleIssuesOutcome);
        }
        return ServiceOutcomeImpl.ok(projectIdsCallback.getProjectIds());
    }

    @Override
    @Nonnull
    public ServiceOutcome<CollectIssuesResult> getMissingParents(ApplicationUser user, RapidView rapidView, List<RapidIssueEntry> issues, CardLayoutField.Mode mode) {
        return this.getMissingOrHiddenParents(user, rapidView, issues, mode, true, true);
    }

    @Override
    @Nonnull
    public ServiceOutcome<CollectIssuesResult> getMissingOrHiddenParents(ApplicationUser user, RapidView rapidView, List<RapidIssueEntry> issues, CardLayoutField.Mode mode) {
        return this.getMissingOrHiddenParents(user, rapidView, issues, mode, false, true);
    }

    private ServiceOutcome<CollectIssuesResult> getMissingOrHiddenParents(ApplicationUser user, RapidView rapidView, List<RapidIssueEntry> issues, CardLayoutField.Mode mode, boolean includeHidden, boolean includeRestricted) {
        HashSet<Long> availableParentIds = new HashSet<Long>();
        HashSet<Long> requestedParentIds = new HashSet<Long>();
        for (RapidIssueEntry issue : issues) {
            Long parentId = issue.getParentId();
            if (parentId != null) {
                requestedParentIds.add(parentId);
                continue;
            }
            if (!includeHidden && issue.hidden.booleanValue()) continue;
            availableParentIds.add(issue.getIssueId());
        }
        HashSet<Long> missingParentIds = new HashSet<Long>(requestedParentIds);
        missingParentIds.removeAll(availableParentIds);
        boolean loadDaysInColumn = false;
        ServiceOutcome<CollectIssuesResult> outcome = this.collectIssuesById(user, rapidView, missingParentIds, loadDaysInColumn, mode, (Set<Long>)ImmutableSet.of());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        ImmutableSet.Builder ret = ImmutableSet.builder();
        List<RapidIssueEntry> missingParentsObtained = outcome.get().getIssues();
        ret.addAll(missingParentsObtained);
        missingParentsObtained.stream().map(RapidIssueEntry::getIssueId).filter(Objects::nonNull).forEach(missingParentIds::remove);
        if (includeRestricted && !missingParentIds.isEmpty()) {
            missingParentIds.stream().map(id -> Pair.of((Object)id, (Object)this.issueManager.getIssueObject(id))).map(this::missingOrRestrictedIssueToRapidIssueEntry).forEach(arg_0 -> ((ImmutableSet.Builder)ret).add(arg_0));
        }
        CollectIssuesResult issuesResult = outcome.get();
        return ServiceOutcomeImpl.ok(new CollectIssuesResult((List<RapidIssueEntry>)ret.build().asList(), issuesResult.getProjects(), issuesResult.getExtraFields(), issuesResult.isEmptyFilterBoard(), issuesResult.getEntityData()));
    }

    @Nonnull
    private RapidIssueEntry missingOrRestrictedIssueToRapidIssueEntry(@Nonnull Pair<Long, MutableIssue> issueData) {
        if (issueData.getRight() != null) {
            return this.restrictedIssueToRapidIssueEntry((Issue)issueData.getRight());
        }
        return this.missingIssueToRapidIssueEntry((Long)issueData.getLeft());
    }

    @Nonnull
    private RapidIssueEntry missingIssueToRapidIssueEntry(@Nonnull Long parentId) {
        RapidIssueEntry rie = new RapidIssueEntry();
        rie.id = parentId;
        rie.key = "" + parentId;
        rie.summary = "";
        rie.hidden = true;
        return rie;
    }

    @Nonnull
    private RapidIssueEntry restrictedIssueToRapidIssueEntry(@Nonnull Issue issue) {
        RapidIssueEntry rie = new RapidIssueEntry();
        rie.id = issue.getId();
        rie.key = issue.getKey();
        rie.summary = "";
        rie.hidden = true;
        return rie;
    }

    @Override
    public ServiceOutcome<CollectIssuesResult> getIssuesByKeys(ApplicationUser user, RapidView rapidView, Set<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return ServiceOutcomeImpl.ok(CollectIssuesResult.empty());
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        builder.where().issue().in(issueKeys.toArray(new String[issueKeys.size()])).endWhere().orderBy().issueKey(SortOrder.ASC);
        Query query = builder.buildQuery();
        boolean sorted = true;
        Predicate visiblePredicate = Predicates.alwaysTrue();
        boolean exactQueryMatch = true;
        boolean loadDaysInColumn = false;
        return this.collectIssues(user, rapidView, query, loadDaysInColumn, sorted, (Predicate<Long>)visiblePredicate, exactQueryMatch, ExtraFieldsContext.NONE);
    }

    @Override
    public ServiceOutcome<DateTime> getEpicsLastUpdated(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<JqlQueryBuilder> epicsQueryOutcome = this.epicsQueryHelper.getEpicsQuery(user, rapidView);
        if (epicsQueryOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(epicsQueryOutcome);
        }
        IssueCountAndLastUpdatedCollector collector = new IssueCountAndLastUpdatedCollector();
        Query query = epicsQueryOutcome.getValue().buildQuery();
        ServiceOutcome<Void> findOutcome = this.issueDataService.findWithServiceOutcome(user, query, collector);
        if (findOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(findOutcome);
        }
        return ServiceOutcomeImpl.ok(collector.getLastUpdatedDate());
    }

    @Override
    @Nonnull
    public ServiceOutcome<CollectIssuesResult> getIssuesById(ApplicationUser user, RapidView rapidView, Set<Long> issueIds, boolean loadDaysInColumn, CardLayoutField.Mode mode, Set<Long> activeQuickFilters) {
        ServiceOutcome<CollectIssuesResult> outcome = this.collectIssuesById(user, rapidView, issueIds, loadDaysInColumn, mode, activeQuickFilters);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        if (outcome.getValue().getIssues().size() != issueIds.size()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "Unable to find the requested issues. id=%s", issueIds);
        }
        return outcome;
    }

    private ServiceOutcome<CollectIssuesResult> collectIssuesById(ApplicationUser user, RapidView rapidView, Set<Long> issueIds, boolean loadDaysInColumn, CardLayoutField.Mode mode, Set<Long> activeQuickFilters) {
        if (issueIds.isEmpty()) {
            HashSet emptySet = new HashSet();
            return ServiceOutcomeImpl.ok(CollectIssuesResult.empty());
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        builder.where().issue().in(issueIds.toArray(new Long[issueIds.size()]));
        Query query = builder.buildQuery();
        ServiceOutcome<Predicate<Long>> visiblePredicateOutcome = this.visiblePredicateForJQL(user, rapidView, builder.buildQuery(), activeQuickFilters);
        if (visiblePredicateOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(visiblePredicateOutcome);
        }
        Predicate<Long> visiblePredicate = visiblePredicateOutcome.get();
        ServiceOutcome<CollectIssuesResult> collectResult = this.collectIssues(user, rapidView, query, loadDaysInColumn, false, visiblePredicate, true, ExtraFieldsContext.create(rapidView, mode));
        if (!collectResult.isValid()) {
            return ServiceOutcomeImpl.error(collectResult);
        }
        return collectResult;
    }

    private ServiceOutcome<Predicate<Long>> visiblePredicateForJQL(ApplicationUser user, RapidView rapidView, Query query, Set<Long> activeQuickFilters) {
        if (activeQuickFilters == null || activeQuickFilters.isEmpty()) {
            return ServiceOutcomeImpl.ok(Predicates.alwaysTrue());
        }
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (rapidViewQuery.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        ServiceOutcome<ClauseToAdd> quickFilterClause = this.rapidViewQueryService.getQuickFilterClause(user, rapidView, activeQuickFilters);
        if (quickFilterClause.isInvalid()) {
            return ServiceOutcomeImpl.error(quickFilterClause);
        }
        JqlQueryBuilder visibleIssueQuery = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.get()).where().defaultAnd().addClause(query.getWhereClause()).addClause(quickFilterClause.get().getClause()).endWhere();
        return this.visiblePredicateForQuery(user, visibleIssueQuery.buildQuery());
    }

    private ServiceOutcome<Predicate<Long>> visiblePredicateForQuery(ApplicationUser user, Query query) {
        IssueIdNumericCollector issueIdCollector = new IssueIdNumericCollector();
        ServiceOutcome<Void> visibleIssuesOutcome = this.issueDataService.findWithServiceOutcome(user, query, issueIdCollector);
        if (!visibleIssuesOutcome.isValid()) {
            return ServiceOutcomeImpl.error(visibleIssuesOutcome);
        }
        return ServiceOutcomeImpl.ok(Predicates.in(issueIdCollector.getNumericIssueIds()));
    }

    private ServiceOutcome<CollectIssuesResult> collectIssues(ApplicationUser user, RapidView rapidView, Query collectIssuesQuery, boolean loadDaysInColumn, boolean sorted, Predicate<Long> visiblePredicate, boolean exactQueryMatch, ExtraFieldsContext extraFieldsContext) {
        return this.collectIssues(user, rapidView, collectIssuesQuery, loadDaysInColumn, sorted, visiblePredicate, exactQueryMatch, null, null, extraFieldsContext);
    }

    private ServiceOutcome<CollectIssuesResult> collectIssues(ApplicationUser user, RapidView rapidView, Query collectIssuesQuery, boolean loadDaysInColumn, boolean sorted, Predicate<Long> visiblePredicate, boolean exactQueryMatch, IssueDataCallback anotherCallback, RapidIssueEntryCallbackComponent anotherComponent, ExtraFieldsContext extraFieldsContext) {
        ServiceOutcome<Void> result;
        long start = System.currentTimeMillis();
        ServiceOutcome<RapidIssueEntryCallback> poolIssueCallbackOutcome = this.createCallback(user, rapidView, visiblePredicate);
        if (!poolIssueCallbackOutcome.isValid()) {
            return ServiceOutcomeImpl.error(poolIssueCallbackOutcome);
        }
        RapidIssueEntryCallback rapidIssueEntryCallback = poolIssueCallbackOutcome.getValue();
        if (anotherComponent != null) {
            rapidIssueEntryCallback.addCallbackComponent(anotherComponent);
        }
        rapidIssueEntryCallback.addCallbackComponent(new FixVersionCallbackComponent());
        if (this.flagCustomFieldProvider.doesDefaultFieldExist()) {
            CustomField flagCustomField = this.flagCustomFieldProvider.getOrCreateDefaultField();
            rapidIssueEntryCallback.addCallbackComponent(new FlaggingCallbackComponent(flagCustomField));
        }
        CustomField epicLinkCustomField = this.epicCustomFieldService.getDefaultEpicLinkField();
        rapidIssueEntryCallback.addCallbackComponent(new EpicCallbackComponent(user, this.extraFieldsHelper, epicLinkCustomField, rapidIssueEntryCallback.getEntityData()));
        rapidIssueEntryCallback.addCallbackComponent(new AssigneeCallbackComponent(user, this.avatarService, this.jiraAvatarService));
        Option<AbstractColumnStatisticsCallback> columnStatisticsCallback = this.columnStatisticsCallbackFactory.createCallback(rapidView);
        if (!columnStatisticsCallback.isEmpty()) {
            rapidIssueEntryCallback.addCallbackComponent((RapidIssueEntryCallbackComponent)columnStatisticsCallback.get());
        }
        List<Object> extraFields = Collections.emptyList();
        if (extraFieldsContext.isValid()) {
            ServiceOutcome<List<NavigableField>> extraFieldsOutcome = this.cardLayoutFieldService.getCardLayoutFields(extraFieldsContext.getRapidView(), extraFieldsContext.getMode());
            if (!extraFieldsOutcome.isValid()) {
                return ServiceOutcomeImpl.error(extraFieldsOutcome);
            }
            extraFields = extraFieldsOutcome.getValue();
            if (!extraFields.isEmpty()) {
                rapidIssueEntryCallback.addCallbackComponent(new ExtraFieldsCallbackComponent(user, this.extraFieldsHelper, extraFields));
            }
        }
        IssueDataCallback callback = rapidIssueEntryCallback;
        if (anotherCallback != null) {
            callback = ComposedIssueDataCallback.of((IssueDataCallback[])new IssueDataCallback[]{rapidIssueEntryCallback, anotherCallback});
        }
        ServiceOutcome<Void> outcome = sorted ? this.issueDataService.findAndSortWithServiceOutcome(user, collectIssuesQuery, callback, PagerFilter.getUnlimitedFilter()) : this.issueDataService.findWithServiceOutcome(user, collectIssuesQuery, callback);
        this.perfLog("collectIssues (search and callback) ", start);
        this.performanceLogger.debug("collectIssues (callback only) %dms", rapidIssueEntryCallback.getTotalDuration());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        List<RapidIssueEntry> issueEntries = this.fillParentKeys(user, rapidIssueEntryCallback.getIssues());
        if (loadDaysInColumn && !(result = this.loadDaysInColumn(user, rapidView, collectIssuesQuery, issueEntries)).isValid()) {
            return ServiceOutcomeImpl.error(result);
        }
        List<ProjectEntry> projects = rapidIssueEntryCallback.getProjects();
        return ServiceOutcomeImpl.ok(new CollectIssuesResult(issueEntries, projects, extraFields, collectIssuesQuery instanceof EmptyFilterQueryWrapper, rapidIssueEntryCallback.getEntityData()));
    }

    private List<RapidIssueEntry> fillParentKeys(ApplicationUser user, List<RapidIssueEntry> issueEntries) {
        Map<Long, String> loadedIssueKeys = issueEntries.stream().collect(Collectors.toMap(issue -> issue.id, issue -> issue.key));
        Set requestedParentIds = issueEntries.stream().map(issue -> issue.parentId).filter(Objects::nonNull).collect(Collectors.toSet());
        Long[] missingParentIds = (Long[])requestedParentIds.stream().filter(id -> !loadedIssueKeys.containsKey(id)).toArray(Long[]::new);
        if (missingParentIds.length != 0) {
            loadedIssueKeys.putAll(this.loadMissingParentKeys(user, missingParentIds));
        }
        issueEntries.stream().filter(issue -> issue.parentId != null).forEach(issue -> {
            issue.parentKey = (String)loadedIssueKeys.get(issue.parentId);
        });
        return issueEntries;
    }

    private Map<Long, String> loadMissingParentKeys(ApplicationUser user, Long[] missingParentIds) {
        Query query = JqlQueryBuilder.newBuilder().where().issue().in(missingParentIds).buildQuery();
        ServiceOutcome<SearchResults<Issue>> searchResultsServiceOutcome = this.searchService.searchOverrideSecurity(user, query);
        if (searchResultsServiceOutcome.isValid()) {
            List parents = searchResultsServiceOutcome.get().getResults();
            return parents.stream().collect(Collectors.toMap(Issue::getId, Issue::getKey));
        }
        return Collections.emptyMap();
    }

    @Override
    public ServiceOutcome<List<String>> collectScrumPlanModeIssueKeys(ApplicationUser user, RapidView rapidView, boolean rankable, boolean movedToSprint, int issuesToMoveCount) {
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            Query visibleIssueQuery = this.getScrumPlanModeQuery(user, rapidView);
            ServiceOutcome<CollectIssuesResult> collectIssuesResult = this.collectIssues(user, rapidView, visibleIssueQuery, false, true, (Predicate<Long>)((Predicate)issueId -> true), false, ExtraFieldsContext.NONE);
            List<RapidIssueEntry> issues = ServiceOutcomeHelper.get(collectIssuesResult).getIssues();
            this.publishMoveIssuesEvent(rapidView, rankable, movedToSprint, issuesToMoveCount, issues.size());
            return (List)issues.stream().map(RapidIssueEntry::getIssueKey).collect(CollectorsUtil.toImmutableListWithCapacity((int)issues.size()));
        });
    }

    private Query getScrumPlanModeQuery(ApplicationUser user, RapidView rapidView) throws ServiceOutcomeException {
        Query planModeIssuesQuery = ServiceOutcomeHelper.get(this.rapidViewQueryService.getPlanModeIssuesQuery(user, rapidView));
        return JqlQueryBuilder.newBuilder((Query)planModeIssuesQuery).where().defaultAnd().issueTypeIsStandard().buildQuery();
    }

    private ServiceOutcome<RapidIssueEntryCallback> createCallback(ApplicationUser user, RapidView rapidView, Predicate<Long> visiblePredicate) {
        StatisticsField estimateStatistic = this.estimateStatisticService.getEstimateStatistic(rapidView);
        DocumentStatisticValueResolver estimateStatisticDocumentValueResolver = this.statisticValueResolverFactory.forEstimationStatisticInDocument(estimateStatistic);
        StatisticsField trackingStatistic = this.trackingStatisticService.getTrackingStatistic(rapidView);
        DocumentStatisticValueResolver trackingStatisticDocumentValueResolver = this.statisticValueResolverFactory.forTrackingStatisticInDocument(trackingStatistic);
        RapidIssueEntryCallback callback = new RapidIssueEntryCallback(visiblePredicate, this.constantsManager, this.webUtilities, this.statisticFieldHelper, this.estimateStatisticService, estimateStatisticDocumentValueResolver, this.trackingStatisticService, trackingStatisticDocumentValueResolver, this.statusEntryFactory);
        if (this.cardColorQueryService.supportsIssueDataCallback(rapidView.getCardColorStrategy())) {
            ServiceOutcome<RapidIssueEntryCallbackComponent> poolIssueCallbackComponent = this.cardColorQueryService.createCardColorIssueEntryCallback(user, rapidView, rapidView.getCardColorStrategy());
            if (!poolIssueCallbackComponent.isValid()) {
                return ServiceOutcomeImpl.error(poolIssueCallbackComponent);
            }
            callback.addCallbackComponent(poolIssueCallbackComponent.getValue());
        }
        return ServiceOutcomeImpl.ok(callback);
    }

    private ServiceOutcome<Void> loadDaysInColumn(ApplicationUser user, RapidView rapidView, Query query, List<RapidIssueEntry> issues) {
        JqlQueryBuilder builder = QueryUtils.clearOrderByClause(query);
        HashMap<Long, RapidIssueEntry> rapidIssueEntries = new HashMap<Long, RapidIssueEntry>();
        for (RapidIssueEntry entry : issues) {
            rapidIssueEntries.put(entry.getIssueId(), entry);
        }
        long start = System.currentTimeMillis();
        Map<Status, Column> columnsByStatus = this.columnService.getColumnsByStatus(rapidView);
        List<Status> orderedStatuses = this.columnService.getOrderedStatuses(rapidView);
        DaysInColumnCallback collector = new DaysInColumnCallback(rapidIssueEntries, columnsByStatus, orderedStatuses, this.constantsManager);
        ServiceOutcome<Void> outcome = this.issueStatusHistoryService.collectStatusHistory(user, builder.buildQuery(), collector);
        this.perfLog("days in column for issues", start);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> loadBacklogTrackingStatisticValues(ApplicationUser user, RapidView rapidView, RapidIssueEntry entry) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where().defaultAnd().sub().issue().eq(entry.id).or().issueParent().eq(entry.id).endsub().endWhere();
        return this.loadAggregateTrackingStatistic(user, rapidView, Collections.singletonList(entry), builder.buildQuery());
    }

    private ServiceOutcome<Void> loadBacklogTrackingStatisticValues(ApplicationUser user, RapidView rapidView, List<RapidIssueEntry> issues) {
        ServiceOutcome<Query> backlogWithSubtasksQueryOutcome = this.rapidViewQueryService.getBacklogQuery(user, rapidView, true);
        if (!backlogWithSubtasksQueryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(backlogWithSubtasksQueryOutcome);
        }
        return this.loadAggregateTrackingStatistic(user, rapidView, issues, backlogWithSubtasksQueryOutcome.getValue());
    }

    private ServiceOutcome<Void> loadAggregateTrackingStatistic(ApplicationUser user, RapidView rapidView, List<RapidIssueEntry> issues, Query query) {
        StatisticsField trackingStatistic = this.trackingStatisticService.getTrackingStatistic(rapidView);
        if (!trackingStatistic.isEnabled()) {
            return ServiceOutcomeImpl.ok();
        }
        DocumentStatisticValueResolver trackingStatisticDocumentValueResolver = this.statisticValueResolverFactory.forTrackingStatisticInDocument(trackingStatistic);
        StatisticFieldAggregationCallback callback = new StatisticFieldAggregationCallback(trackingStatisticDocumentValueResolver);
        ServiceOutcome<Void> searchOutcome = this.issueDataService.findWithServiceOutcome(user, query, callback);
        if (!searchOutcome.isValid()) {
            return ServiceOutcomeImpl.error(searchOutcome);
        }
        Map<Long, Double> trackingStatisticValues = callback.getValuePerIssue();
        for (RapidIssueEntry entry : issues) {
            Double newValue = trackingStatisticValues.get(entry.id);
            if (newValue == null) continue;
            entry.trackingStatistic = this.statisticFieldHelper.createTrackingStatisticValue(trackingStatisticDocumentValueResolver, entry.projectId, entry.typeId, newValue);
        }
        return ServiceOutcomeImpl.ok();
    }

    private EpicMetadataCallbackComponent createEpicMetadataCallbackComponent(CustomField epicLabelField, CustomField epicColorField, CustomField epicStatusField) {
        Option<com.atlassian.jira.issue.customfields.option.Option> doneEpicStatusOption = this.epicCustomFieldService.getDoneEpicStatusOption();
        String epicDoneStatusValue = doneEpicStatusOption.isDefined() ? ((com.atlassian.jira.issue.customfields.option.Option)doneEpicStatusOption.get()).getOptionId().toString() : "";
        return new EpicMetadataCallbackComponent(epicLabelField, epicColorField, epicStatusField, epicDoneStatusValue);
    }

    private void perfLog(String message, long start) {
        if (!this.performanceLogger.isDebugEnabled()) {
            return;
        }
        try {
            this.performanceLogger.debug(message + "  %dms", System.currentTimeMillis() - start);
        }
        catch (RuntimeException e) {
            this.performanceLogger.error("Unable to format message: " + message, new Object[0]);
            this.performanceLogger.exception(e);
        }
    }

    private void publishCollectIssuesEvent(RapidView rapidView, CardLayoutField.Mode mode, CollectIssuesResult collectIssuesResult, long duration) {
        int issuesSize = collectIssuesResult.getIssues().size();
        CollectIssuesEvent collectIssuesEvent = CollectIssuesEvent.create(rapidView, mode, collectIssuesResult.getExtraFields(), duration, issuesSize);
        this.eventPublisher.publish((Object)collectIssuesEvent);
    }

    private void publishMoveIssuesEvent(RapidView rapidView, boolean rankable, boolean movedToSprint, int issuesToMoveCount, int issuesTotalCount) {
        MoveIssuesEvent moveIssuesEvent = MoveIssuesEvent.create(rapidView.isSprintSupportEnabled(), rankable, movedToSprint, issuesToMoveCount, issuesTotalCount);
        this.eventPublisher.publish((Object)moveIssuesEvent);
    }

    private boolean isDaysInColumnGlobalEnabled() {
        return this.jiraSoftwareFeaturesService.isFeatureEnabled(JiraSoftwareFeature.DAYS_IN_COLUMN);
    }
}

