/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.FixVersionCallbackComponent;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.greenhopper.web.rapid.issue.StatisticFieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.list.EntityData;
import com.atlassian.greenhopper.web.rapid.list.EpicCallbackComponent;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueConstantEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueConstantEntryCache;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import com.atlassian.greenhopper.web.rapid.list.RapidStatusEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidStatusEntryCache;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntry;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class RapidIssueEntryCallback
extends AbstractCompoundDataCallback {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final Set<String> FIELDS = ImmutableSet.of((Object)"projid", (Object)"issue_parenttask", (Object)"type", (Object)"summary", (Object)"priority", (Object)"resolution", (Object[])new String[]{"status"});
    private List<RapidIssueEntry> issues = new LinkedList<RapidIssueEntry>();
    private EntityData entityData = new EntityData();
    private Set<String> projectIds = new HashSet<String>();
    private List<ProjectEntry> projects = new LinkedList<ProjectEntry>();
    private long totalDuration = 0L;
    private final ConstantsManager constantsManager;
    private final WebUtilities webUtilities;
    private final StatisticsField estimateStatistic;
    private final EstimateStatisticService estimateStatisticService;
    private final StatisticFieldHelper statisticFieldHelper;
    private final DocumentStatisticValueResolver estimateDocumentStatisticValueResolver;
    private final StatisticsField trackingStatistic;
    private final TrackingStatisticService trackingStatisticService;
    private final DocumentStatisticValueResolver trackingDocumentStatisticValueResolver;
    private final StatusEntryFactory statusEntryFactory;
    private final Predicate<Long> visiblePredicate;
    private List<RapidIssueEntryCallbackComponent> baseCallbackComponents;
    private List<RapidIssueEntryCallbackComponent> visibleCallbackComponents;
    private Set<String> targetFields;
    private final Supplier<WebUtilities> webUtilitiesSupplier = new Supplier<WebUtilities>(){

        public WebUtilities get() {
            return RapidIssueEntryCallback.this.webUtilities;
        }
    };
    private final Supplier<StatusEntryFactory> statusEntryFactorySupplier = new Supplier<StatusEntryFactory>(){

        public StatusEntryFactory get() {
            return RapidIssueEntryCallback.this.statusEntryFactory;
        }
    };
    private final RapidIssueConstantEntryCache<Priority, RapidIssueConstantEntry<Priority>> priorityCache = new RapidIssueConstantEntryCache(this.webUtilitiesSupplier, new Function<String, Priority>(){

        public Priority apply(@Nullable String input) {
            return RapidIssueEntryCallback.this.constantsManager.getPriorityObject(input);
        }
    });
    private final RapidIssueConstantEntryCache<Resolution, RapidIssueConstantEntry<Resolution>> resolutionCache = new RapidIssueConstantEntryCache(this.webUtilitiesSupplier, new Function<String, Resolution>(){

        public Resolution apply(@Nullable String input) {
            return RapidIssueEntryCallback.this.constantsManager.getResolutionObject(input);
        }
    });
    private final RapidIssueConstantEntryCache<IssueType, RapidIssueConstantEntry<IssueType>> typeCache = new RapidIssueConstantEntryCache(this.webUtilitiesSupplier, new Function<String, IssueType>(){

        public IssueType apply(@Nullable String input) {
            return RapidIssueEntryCallback.this.constantsManager.getIssueTypeObject(input);
        }
    });
    private final RapidStatusEntryCache statusCache = new RapidStatusEntryCache(this.webUtilitiesSupplier, this.statusEntryFactorySupplier, new Function<String, Status>(){

        public Status apply(@Nullable String input) {
            return RapidIssueEntryCallback.this.constantsManager.getStatusObject(input);
        }
    });

    public RapidIssueEntryCallback(Predicate<Long> visiblePredicate, ConstantsManager constantsManager, WebUtilities webUtilities, StatisticFieldHelper statisticFieldHelper, EstimateStatisticService estimateStatisticService, DocumentStatisticValueResolver estimateDocumentStatisticValueResolver, TrackingStatisticService trackingStatisticService, DocumentStatisticValueResolver trackingDocumentStatisticValueResolver, StatusEntryFactory statusEntryFactory) {
        this.visiblePredicate = visiblePredicate;
        this.constantsManager = constantsManager;
        this.webUtilities = webUtilities;
        this.statisticFieldHelper = statisticFieldHelper;
        this.estimateDocumentStatisticValueResolver = estimateDocumentStatisticValueResolver;
        this.estimateStatistic = estimateDocumentStatisticValueResolver.getStatisticsField();
        this.estimateStatisticService = estimateStatisticService;
        this.trackingDocumentStatisticValueResolver = trackingDocumentStatisticValueResolver;
        this.trackingStatistic = trackingDocumentStatisticValueResolver.getStatisticsField();
        this.trackingStatisticService = trackingStatisticService;
        this.statusEntryFactory = statusEntryFactory;
        this.visibleCallbackComponents = new ArrayList<RapidIssueEntryCallbackComponent>();
        this.baseCallbackComponents = new ArrayList<RapidIssueEntryCallbackComponent>();
    }

    public void addCallbackComponent(@Nullable RapidIssueEntryCallbackComponent component) {
        if (component != null) {
            if (component instanceof EpicCallbackComponent || component instanceof FixVersionCallbackComponent) {
                this.baseCallbackComponents.add(component);
            } else {
                this.visibleCallbackComponents.add(component);
            }
        }
    }

    public List<RapidIssueEntry> getIssues() {
        return this.issues;
    }

    public EntityData getEntityData() {
        return this.entityData;
    }

    public List<ProjectEntry> getProjects() {
        return this.projects;
    }

    @Override
    public Set<String> getFields() {
        if (this.targetFields != null) {
            return this.targetFields;
        }
        this.targetFields = new HashSet<String>(FIELDS);
        if (this.estimateStatistic.isFieldBased()) {
            this.targetFields.add(this.estimateDocumentStatisticValueResolver.getDocumentId());
        }
        if (this.trackingStatistic.isFieldBased()) {
            this.targetFields.add(this.trackingDocumentStatisticValueResolver.getDocumentId());
        }
        for (RapidIssueEntryCallbackComponent component : this.baseCallbackComponents) {
            this.targetFields.addAll(component.getFields());
        }
        for (RapidIssueEntryCallbackComponent component : this.visibleCallbackComponents) {
            this.targetFields.addAll(component.getFields());
        }
        return this.targetFields;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    @Override
    public void fieldData(Long issueId, String issueKey, IssueFieldValueProvider data) {
        long a = System.currentTimeMillis();
        RapidIssueEntry entry = this.visiblePredicate.apply((Object)issueId) ? this.createVisibleEntry(issueId, issueKey, data) : this.createHiddenEntry(issueId, issueKey, data);
        this.issues.add(entry);
        this.totalDuration += System.currentTimeMillis() - a;
    }

    @Override
    public boolean requiresIssueDoc() {
        return true;
    }

    private RapidIssueEntry createHiddenEntry(Long issueId, String issueKey, IssueFieldValueProvider data) {
        RapidIssueEntry entry = this.createBaseEntry(issueId, issueKey, data);
        entry.hidden = true;
        return entry;
    }

    private RapidIssueEntry createVisibleEntry(Long issueId, String issueKey, IssueFieldValueProvider data) {
        RapidIssueEntry entry = this.createBaseEntry(issueId, issueKey, data);
        entry.hidden = false;
        entry.summary = data.get("summary");
        this.handlePriority(entry, data);
        this.handleResolutionDone(entry, data);
        this.handleIssueType(entry, data);
        for (RapidIssueEntryCallbackComponent component : this.visibleCallbackComponents) {
            component.processFieldData(issueId, issueKey, data, entry);
        }
        return entry;
    }

    private RapidIssueEntry createBaseEntry(Long issueId, String issueKey, IssueFieldValueProvider data) {
        RapidIssueEntry entry = new RapidIssueEntry();
        entry.id = issueId;
        entry.key = issueKey;
        this.handleSubtask(entry, data);
        this.handleStatisticsFields(entry, data);
        this.handleProject(entry, data);
        this.handleStatus(entry, data);
        for (RapidIssueEntryCallbackComponent component : this.baseCallbackComponents) {
            component.processFieldData(issueId, issueKey, data, entry);
        }
        return entry;
    }

    private void handleProject(RapidIssueEntry entry, IssueFieldValueProvider data) {
        Long projectId;
        String projectIdString = data.get("projid");
        entry.projectId = projectId = NumberUtils.toLong(projectIdString);
        if (!this.projectIds.contains(projectIdString)) {
            this.projectIds.add(projectIdString);
            ProjectEntry projectEntry = new ProjectEntry();
            projectEntry.id = projectId;
            this.projects.add(projectEntry);
        }
    }

    private void handleStatisticsFields(RapidIssueEntry entry, IssueFieldValueProvider data) {
        this.handleEstimateStatistic(entry, data);
        this.handleTrackingStatistic(entry, data);
    }

    private void handleEstimateStatistic(RapidIssueEntry entry, IssueFieldValueProvider data) {
        if (!this.estimateStatisticService.isEstimateStatisticValidAndEnabled(this.estimateStatistic)) {
            return;
        }
        if (this.estimateStatisticService.isEstimateStatisticFieldAndNotApplicable(this.estimateStatistic, this.getProjectId(data), this.getIssueTypeId(data))) {
            return;
        }
        if (this.estimateStatistic.getConfig().getType() == StatisticsFieldConfig.Type.ISSUE_COUNT) {
            entry.estimateStatistic = this.statisticFieldHelper.createIssueCountEstimateStatistic();
        } else {
            String documentId = this.estimateDocumentStatisticValueResolver.getDocumentId();
            String indexValue = data.get(documentId);
            entry.estimateStatistic = this.statisticFieldHelper.createEstimateStatistic(this.getProjectId(data), this.getIssueTypeId(data), indexValue, this.estimateDocumentStatisticValueResolver);
        }
    }

    private void handleTrackingStatistic(RapidIssueEntry entry, IssueFieldValueProvider data) {
        if (!this.trackingStatisticService.isTrackingStatisticValidAndEnabled(this.trackingStatistic)) {
            return;
        }
        if (this.trackingStatisticService.isTrackingStatisticFieldAndNotApplicable(this.trackingStatistic, this.getProjectId(data), this.getIssueTypeId(data))) {
            return;
        }
        if (this.trackingStatistic.getConfig().getType() == StatisticsFieldConfig.Type.ISSUE_COUNT) {
            entry.trackingStatistic = this.statisticFieldHelper.createIssueCountEstimateStatistic();
        } else {
            String documentId = this.trackingDocumentStatisticValueResolver.getDocumentId();
            String indexValue = data.get(documentId);
            entry.trackingStatistic = this.statisticFieldHelper.createTrackingStatistic(this.getProjectId(data), this.getIssueTypeId(data), indexValue, this.trackingDocumentStatisticValueResolver);
        }
    }

    private void handlePriority(RapidIssueEntry entry, IssueFieldValueProvider data) {
        String priorityId = data.get("priority");
        RapidIssueConstantEntry<Priority> details = this.priorityCache.get(priorityId);
        if (details != null) {
            entry.priorityId = details.id;
            this.entityData.collectPriority(details.id, details.name, details.url);
        }
    }

    private void handleResolutionDone(RapidIssueEntry entry, IssueFieldValueProvider data) {
        String resolutionId = data.get("resolution");
        entry.done = this.resolutionCache.get(resolutionId) != null;
    }

    private void handleIssueType(RapidIssueEntry entry, IssueFieldValueProvider data) {
        String typeId = data.get("type");
        RapidIssueConstantEntry<IssueType> details = this.typeCache.get(typeId);
        entry.typeId = details.id;
        this.entityData.collectType(details.id, details.name, details.url);
    }

    private void handleStatus(RapidIssueEntry entry, IssueFieldValueProvider data) {
        String statusId = data.get("status");
        RapidStatusEntry details = (RapidStatusEntry)this.statusCache.get(statusId);
        if (details != null) {
            entry.statusId = statusId;
            if (details.statusEntry != null) {
                this.entityData.collectStatus(statusId, details.name, details.statusEntry.iconUrl, details.statusEntry);
            }
        }
    }

    private void handleSubtask(RapidIssueEntry entry, IssueFieldValueProvider data) {
        entry.parentId = NumberUtils.toLong(data.get("issue_parenttask"));
    }

    private Long getProjectId(IssueFieldValueProvider data) {
        try {
            return Long.parseLong(data.get("projid"));
        }
        catch (NumberFormatException nfe) {
            this.log.error("Unable to parse project id", new Object[0]);
            this.log.exception(nfe);
            return null;
        }
    }

    private String getIssueTypeId(IssueFieldValueProvider data) {
        return data.get("type");
    }
}

