/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.web.rapid.list.RapidIssueConstantEntry;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.issue.IssueConstant;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;

public class RapidIssueConstantEntryCache<T extends IssueConstant, R extends RapidIssueConstantEntry<T>> {
    private final Map<String, R> cachedDetails = new HashMap<String, R>();
    private final Supplier<WebUtilities> webUtilitiesSupplier;
    private final Function<String, T> resolver;

    public RapidIssueConstantEntryCache(Supplier<WebUtilities> webUtilitiesSupplier, Function<String, T> resolver) {
        this.webUtilitiesSupplier = webUtilitiesSupplier;
        this.resolver = resolver;
    }

    public R get(String id) {
        RapidIssueConstantEntry<Object> details = (RapidIssueConstantEntry)this.cachedDetails.get(id);
        if (details != null) {
            return (R)details;
        }
        if (this.cachedDetails.containsKey(id)) {
            return null;
        }
        IssueConstant constant = (IssueConstant)this.resolver.apply((Object)id);
        if (constant != null) {
            details = this.newRapidEntry(constant, (WebUtilities)this.webUtilitiesSupplier.get());
        }
        this.cachedDetails.put(id, details);
        return (R)details;
    }

    protected R newRapidEntry(T constant, WebUtilities webUtilities) {
        return (R)new RapidIssueConstantEntry<T>(constant, webUtilities);
    }
}

