/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.issue.comment.BulkCommentService;
import com.atlassian.greenhopper.service.issue.flagging.FlagService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@Path(value="xboard/issue/flag")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@AnonymousAllowed
public class FlagResource
extends AbstractResource {
    private final IssueHelper issueHelper;
    private final FlagService flagService;
    private final BulkCommentService bulkCommentService;
    private final ErrorCollectionTransformer errorCollectionTransformer;

    public FlagResource(IssueHelper issueHelper, FlagService flagService, BulkCommentService bulkCommentService, ErrorCollectionTransformer errorCollectionTransformer) {
        this.issueHelper = issueHelper;
        this.flagService = flagService;
        this.bulkCommentService = bulkCommentService;
        this.errorCollectionTransformer = errorCollectionTransformer;
    }

    @Path(value="/flag")
    @POST
    public Response flag(final FlagRequest flagRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                Collection issues = FlagResource.this.check(FlagResource.this.issueHelper.findIssuesList(flagRequest.issueKeys));
                FlagService.Result flagServiceResult = FlagResource.this.check(FlagResource.this.flagService.flag(FlagResource.this.getUser(), issues, flagRequest.flag));
                ErrorCollection errorCollection = flagServiceResult.getErrorCollection();
                if (StringUtils.isNotBlank((CharSequence)flagRequest.comment) && !flagServiceResult.getUpdatedIssues().isEmpty()) {
                    BulkCommentService.Result commentServiceResult = FlagResource.this.check(FlagResource.this.bulkCommentService.addComment(FlagResource.this.getUser(), flagServiceResult.getUpdatedIssues(), flagRequest.comment, new CommentVisibility(flagRequest.commentVisibility), Optional.ofNullable(flagRequest.temporaryAttachments).orElse(Collections.emptyList())));
                    errorCollection.addAllErrors(commentServiceResult.getErrorCollection());
                }
                if (errorCollection.hasErrors()) {
                    JiraCopiedRestErrorCollection restErrorCollection = JiraCopiedRestErrorCollection.of(FlagResource.this.errorCollectionTransformer.toJiraErrorCollection(errorCollection));
                    return Response.ok((Object)restErrorCollection).cacheControl(CacheControl.never()).build();
                }
                return Response.ok().build();
            }
        });
    }

    @Path(value="/flag")
    @GET
    public Response isFlagged(final @QueryParam(value="issueKey") String issueKey) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                Issue issue = FlagResource.this.check(FlagResource.this.issueHelper.findIssue(issueKey));
                Boolean flagged = FlagResource.this.flagService.isFlagged(issue);
                return Response.ok((Object)flagged).build();
            }
        });
    }

    @XmlRootElement
    public static class FlagRequest
    extends RestTemplate {
        @XmlElement
        public Set<String> issueKeys;
        @XmlElement
        public boolean flag;
        @XmlElement
        public String comment;
        @XmlElement
        public String commentVisibility;
        @XmlElement
        public String formToken;
        @XmlElement
        Collection<String> temporaryAttachments;
    }
}

