/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.rapid.view.cardlayout.CardLayoutFieldService;
import com.atlassian.greenhopper.web.rapid.issue.IssueEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.DefaultCustomFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.IssueLinksSystemFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SystemFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtraFieldsHelper {
    @Autowired
    private IssueFactory issueFactory;
    @Autowired
    private FieldLayoutManager fieldLayoutManager;
    @Autowired
    private FieldHelper fieldHelper;
    @Autowired
    CardLayoutFieldService cardLayoutFieldService;
    @Autowired
    FieldManager fieldManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private IssueEntryFactory issueEntryFactory;
    private static final ImmutableMap<String, Boolean> DISPLAY_PARAMS = ImmutableMap.builder().put((Object)"textOnly", (Object)Boolean.TRUE).put((Object)"readonly", (Object)Boolean.TRUE).put((Object)"nolink", (Object)Boolean.TRUE).build();

    @Nonnull
    public List<FieldEntry> renderFields(ApplicationUser user, List<NavigableField> navigableFields, Document issueDoc) {
        ArrayList<FieldEntry> fieldEntries = new ArrayList<FieldEntry>();
        Issue issue = this.issueFactory.getIssue(issueDoc);
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        for (NavigableField navigableField : navigableFields) {
            FieldEntry fieldEntry = this.renderField(i18n, fieldLayout, user, issue, navigableField);
            if (fieldEntry == null) continue;
            fieldEntries.add(fieldEntry);
        }
        return fieldEntries;
    }

    @Nullable
    public FieldEntry renderField(ApplicationUser user, NavigableField navigableField, Document issueDoc) {
        Issue issue = this.issueFactory.getIssue(issueDoc);
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        return this.renderField(i18n, fieldLayout, user, issue, navigableField);
    }

    @Nullable
    private FieldEntry renderField(I18n2 i18n, FieldLayout fieldLayout, ApplicationUser user, Issue issue, NavigableField navigableField) {
        boolean renderField;
        if (navigableField instanceof CustomField) {
            CustomField customField = (CustomField)navigableField;
            renderField = this.fieldHelper.isCustomFieldValid(customField, issue);
        } else {
            renderField = this.fieldHelper.isFieldVisible(navigableField.getId(), issue);
        }
        if (renderField) {
            FieldEntryFactory fieldEntryFactory = this.issueEntryFactory.getFieldEntryFactory((Field)navigableField);
            FieldEntry extraFieldEntry = fieldEntryFactory == null || fieldEntryFactory instanceof IssueLinksSystemFieldEntryFactory || fieldEntryFactory instanceof SystemFieldEntryFactory || fieldEntryFactory instanceof DefaultCustomFieldEntryFactory ? this.createColumnViewEntry(i18n, fieldLayout, issue, navigableField) : fieldEntryFactory.createViewEntry(i18n, issue, user);
            return extraFieldEntry;
        }
        return null;
    }

    private HtmlFieldEntry createColumnViewEntry(I18n2 i18n, FieldLayout fieldLayout, Issue issue, NavigableField navigableField) {
        HtmlFieldEntry htmlFieldEntry = new HtmlFieldEntry();
        htmlFieldEntry.id = navigableField.getId();
        htmlFieldEntry.editable = false;
        htmlFieldEntry.label = i18n.getText(navigableField.getNameKey());
        FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(navigableField.getId());
        htmlFieldEntry.html = navigableField.getColumnViewHtml(fieldLayoutItem, (Map)Maps.newHashMap(DISPLAY_PARAMS), issue).trim();
        htmlFieldEntry.renderer = "html";
        return htmlFieldEntry;
    }
}

