/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import com.atlassian.jira.issue.fields.CustomField;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class EpicMetadataCallbackComponent
implements RapidIssueEntryCallbackComponent {
    String epicLabelFieldId;
    String epicColorFieldId;
    String epicStatusFieldId;
    String epicDoneStatusValue;

    public EpicMetadataCallbackComponent(CustomField epicLabelField, CustomField epicColorField, CustomField epicStatusField, String epicDoneStatusValue) {
        this.epicLabelFieldId = epicLabelField.getId();
        this.epicColorFieldId = epicColorField.getId();
        this.epicStatusFieldId = epicStatusField.getId();
        this.epicDoneStatusValue = epicDoneStatusValue;
    }

    @Override
    public Set<String> getFields() {
        return Sets.newHashSet((Object[])new String[]{this.epicLabelFieldId, this.epicColorFieldId, this.epicStatusFieldId});
    }

    @Override
    public void processFieldData(Long issueId, String issueKey, IssueFieldValueProvider data, RapidIssueEntry entry) {
        String value = data.get(this.epicLabelFieldId);
        if (value != null) {
            entry.epicLabel = value;
        }
        if ((value = data.get(this.epicColorFieldId)) != null) {
            entry.epicColor = value;
        }
        if (StringUtils.isNotEmpty((CharSequence)(value = data.get(this.epicStatusFieldId))) && value.equals(this.epicDoneStatusValue)) {
            entry.hidden = true;
        }
    }
}

