/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCustomFieldIndexer;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.web.rapid.issue.fields.EpicLinkFieldEntry;
import com.atlassian.greenhopper.web.rapid.list.EntityData;
import com.atlassian.greenhopper.web.rapid.list.ExtraFieldsHelper;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;

public class EpicCallbackComponent
implements RapidIssueEntryCallbackComponent {
    private final CustomField epicLinkCustomField;
    private final ExtraFieldsHelper extraFieldsHelper;
    private final ApplicationUser user;
    private final EntityData entityData;

    public EpicCallbackComponent(ApplicationUser user, ExtraFieldsHelper extraFieldsHelper, CustomField epicLinkCustomField, EntityData entityData) {
        this.epicLinkCustomField = epicLinkCustomField;
        this.user = user;
        this.extraFieldsHelper = extraFieldsHelper;
        this.entityData = entityData;
    }

    @Override
    public Set<String> getFields() {
        return Collections.singleton(this.getDocumentId());
    }

    @Override
    public void processFieldData(Long issueId, String issueKey, IssueFieldValueProvider data, RapidIssueEntry entry) {
        String epicId = data.get(this.getDocumentId());
        if (StringUtils.isNotBlank((CharSequence)epicId) && !"-1".equals(epicId)) {
            entry.epicId = epicId;
            EpicLinkFieldEntry fieldEntry = this.entityData.collectEpic(entry.epicId, () -> (EpicLinkFieldEntry)this.extraFieldsHelper.renderField(this.user, (NavigableField)this.epicLinkCustomField, (Document)data.getIssueDoc().get()));
            if (fieldEntry != null) {
                entry.epic = fieldEntry.epicKey;
            }
        }
    }

    private String getDocumentId() {
        return EpicLinkCustomFieldIndexer.getIdFieldId(this.epicLinkCustomField);
    }
}

