/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.issue.fields.EpicLinkFieldEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.MapUtils;

@XmlRootElement
public class EntityData
extends RestTemplate {
    public final Map<String, Map<String, Object>> statuses;
    public final Map<String, Map<String, String>> priorities;
    public final Map<String, Map<String, String>> types = new HashMap<String, Map<String, String>>();
    public final Map<String, Map<String, Object>> epics;

    public EntityData() {
        this.priorities = new HashMap<String, Map<String, String>>();
        this.statuses = new HashMap<String, Map<String, Object>>();
        this.epics = new HashMap<String, Map<String, Object>>();
    }

    private static Map<String, Object> statusObject(String name, String url, Object object) {
        HashMap<String, Object> status = new HashMap<String, Object>();
        MapUtils.safeAddToMap(status, (Object)"statusName", (Object)name);
        MapUtils.safeAddToMap(status, (Object)"statusUrl", (Object)url);
        MapUtils.safeAddToMap(status, (Object)"status", (Object)object);
        return status;
    }

    private static Map<String, String> priorityObject(String name, String url) {
        HashMap<String, String> priority = new HashMap<String, String>();
        MapUtils.safeAddToMap(priority, (Object)"priorityName", (Object)name);
        MapUtils.safeAddToMap(priority, (Object)"priorityUrl", (Object)url);
        return priority;
    }

    private static Map<String, String> typeObject(String name, String url) {
        HashMap<String, String> type = new HashMap<String, String>();
        MapUtils.safeAddToMap(type, (Object)"typeName", (Object)name);
        MapUtils.safeAddToMap(type, (Object)"typeUrl", (Object)url);
        return type;
    }

    private static Map<String, Object> epicObject(EpicLinkFieldEntry fieldEntry) {
        HashMap<String, Object> type = new HashMap<String, Object>();
        MapUtils.safeAddToMap(type, (Object)"epicField", (Object)fieldEntry);
        return type;
    }

    public void collectType(@Nonnull String id, String name, String url) {
        this.types.computeIfAbsent(id, typeId -> EntityData.typeObject(name, url));
    }

    public void collectPriority(@Nonnull String id, String name, String url) {
        this.priorities.computeIfAbsent(id, priorityId -> EntityData.priorityObject(name, url));
    }

    public void collectStatus(@Nonnull String id, String name, String url, Object object) {
        this.statuses.computeIfAbsent(id, statusId -> EntityData.statusObject(name, url, object));
    }

    public EpicLinkFieldEntry collectEpic(String id, Supplier<EpicLinkFieldEntry> field) {
        if (id != null) {
            Map map = this.epics.computeIfAbsent(id, epic -> {
                EpicLinkFieldEntry fieldEntry = (EpicLinkFieldEntry)field.get();
                return EntityData.epicObject(fieldEntry);
            });
            return (EpicLinkFieldEntry)map.get("epicField");
        }
        return null;
    }
}

