/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.service.charts.AbstractIssueHistoryStatusCallback;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.status.Status;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class DaysInColumnCallback
extends AbstractIssueHistoryStatusCallback {
    private List<Status> statuses;
    private Map<Long, SortedSet<Change>> issueStatusChangeBuffer = new HashMap<Long, SortedSet<Change>>();
    private final Map<Long, RapidIssueEntry> issues;
    private DateTime now = new DateTime().withZone(DateTimeZone.UTC);
    private Map<Status, Column> columnsByStatus;
    private final ConstantsManager constantsManager;

    public DaysInColumnCallback(Map<Long, RapidIssueEntry> issues, Map<Status, Column> columnsByStatus, List<Status> statuses, ConstantsManager constantsManager) {
        this.issues = issues;
        this.columnsByStatus = columnsByStatus;
        this.statuses = statuses;
        this.constantsManager = constantsManager;
    }

    @Override
    public Collection<Status> getStatuses() {
        return this.statuses;
    }

    @Override
    public void changedFrom(Long issueId, String issueKey, DateTime changeTime, Status changedFromStatus) {
        RapidIssueEntry issue = this.issues.get(issueId);
        if (issue != null && this.isInSameColumn(this.constantsManager.getStatus(issue.statusId), changedFromStatus) && this.validChangeTime(issueKey, changedFromStatus, changeTime)) {
            this.log.trace("issue %s changed from %s at %tc", issueId, changedFromStatus.getName(), changeTime.getMillis());
            this.addChange(issueId, changeTime, true);
        }
    }

    @Override
    public void changedTo(Long issueId, String issueKey, DateTime changeTime, Status changedToStatus) {
        RapidIssueEntry issue = this.issues.get(issueId);
        if (issue != null && this.isInSameColumn(this.constantsManager.getStatus(issue.statusId), changedToStatus) && this.validChangeTime(issueKey, changedToStatus, changeTime)) {
            this.log.trace("issue %s changed to %s at %tc", issueId, changedToStatus.getName(), changeTime.getMillis());
            this.addChange(issueId, changeTime, false);
        }
    }

    @Override
    public void after(Status status) {
        this.log.debug("==== processing status %s", status.getName());
        for (Map.Entry<Long, SortedSet<Change>> changes : this.issueStatusChangeBuffer.entrySet()) {
            DateTime enteredTime = null;
            long duration = 0L;
            Long issueId = changes.getKey();
            RapidIssueEntry entry = this.issues.get(issueId);
            if (entry.timeInColumn == null) {
                entry.timeInColumn = new RapidIssueEntry.TimeInColumnFieldValue();
            }
            for (Change change : changes.getValue()) {
                if (change.enteredStatus()) {
                    enteredTime = change.changeTime;
                    continue;
                }
                if (enteredTime == null) continue;
                this.log.debug("issue %s recording change for status %s from %tc to %tc", issueId, status.getName(), enteredTime.getMillis(), change.changeTime.getMillis());
                entry.timeInColumn.durationPreviously += change.changeTime.getMillis() - enteredTime.getMillis();
                enteredTime = null;
            }
            if (enteredTime == null) continue;
            this.log.debug("issue %s recording entered status %s at %tc", issueId, status.getName(), enteredTime.getMillis());
            entry.timeInColumn.enteredStatus = enteredTime.getMillis();
        }
        this.issueStatusChangeBuffer.clear();
    }

    private boolean isInSameColumn(Status one, Status another) {
        Column oneColumn = this.columnsByStatus.get(one);
        Column anotherColumn = this.columnsByStatus.get(another);
        return oneColumn != null && anotherColumn != null && oneColumn.equals(anotherColumn);
    }

    private boolean validChangeTime(String issueKey, Status status, DateTime changeTime) {
        if (changeTime.isAfter((ReadableInstant)this.now)) {
            this.log.warn("Issue %s has changed from/to status %s at %tc, which is in the future from now [%tc]. Ignoring this change for the 'days in column' display.", issueKey, status.getName(), changeTime.getMillis(), this.now.getMillis());
            return false;
        }
        return true;
    }

    private void addChange(Long issueId, DateTime time, boolean leave) {
        this.issueStatusChangeBuffer.putIfAbsent(issueId, new TreeSet());
        SortedSet<Change> changes = this.issueStatusChangeBuffer.get(issueId);
        changes.add(new Change(time, leave));
    }

    private static class Change
    implements Comparable<Change> {
        final DateTime changeTime;
        final boolean leave;

        public Change(DateTime changeTime, boolean leave) {
            this.changeTime = changeTime;
            this.leave = leave;
        }

        public boolean enteredStatus() {
            return !this.leave;
        }

        @Override
        public int compareTo(Change other) {
            int result = this.changeTime.compareTo((ReadableInstant)other.changeTime);
            if (result != 0) {
                return result;
            }
            if (this.leave && other.enteredStatus()) {
                return -1;
            }
            if (this.enteredStatus() && other.leave) {
                return 1;
            }
            return 0;
        }
    }
}

