/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CollectIssuesEvent {
    private static final int NORMALISE_THRESHOLD = 100;
    private static final int NORMALISED_ISSUES_LENGTH = 500;
    private static final List<Integer> DURATION_BUCKETS = Lists.newArrayList((Object[])new Integer[]{20000, 10000, 5000, 2000, 1000, 900, 800, 700, 600, 500, 400, 300, 200, 100, 0});
    private final long boardId;
    private final String mode;
    private final List<String> fields;
    private final int fieldCount;
    private final long duration;

    public static CollectIssuesEvent create(RapidView rapidView, CardLayoutField.Mode mode, List<NavigableField> fields, long duration, long numIssues) {
        return new CollectIssuesEvent(rapidView.getId(), mode.getModeName(), CollectIssuesEvent.identifyFields(fields), fields.size(), CollectIssuesEvent.normaliseDuration(duration, numIssues));
    }

    private static List<String> identifyFields(List<NavigableField> fields) {
        if (fields.isEmpty()) {
            return null;
        }
        ArrayList fieldIds = Lists.newArrayList((Iterable)Iterables.transform(fields, (Function)new Function<NavigableField, String>(){

            public String apply(NavigableField navigableField) {
                CustomFieldType customFieldType;
                String id = navigableField instanceof CustomField ? ((customFieldType = ((CustomField)navigableField).getCustomFieldType()) == null ? "unknown" : customFieldType.getKey()) : navigableField.getId();
                return id;
            }
        }));
        Collections.sort(fieldIds);
        return fieldIds;
    }

    private static long normaliseDuration(long duration, long numIssues) {
        if (numIssues <= 0L || duration < 100L) {
            return 0L;
        }
        final long normalised = Math.round(duration * 500L / numIssues);
        return ((Integer)Iterables.find(DURATION_BUCKETS, (Predicate)new Predicate<Integer>(){

            public boolean apply(Integer bucket) {
                return normalised >= (long)bucket.intValue();
            }
        })).intValue();
    }

    private CollectIssuesEvent(long boardId, String mode, List<String> fields, int fieldCount, long duration) {
        this.boardId = boardId;
        this.mode = mode;
        this.fields = fields;
        this.fieldCount = fieldCount;
        this.duration = duration;
    }

    @EventName
    public String getEventName() {
        return "gh.rapidboard." + this.mode + ".collect";
    }

    public long getBoardId() {
        return this.boardId;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public long getDuration() {
        return this.duration;
    }
}

