/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.list;

import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.service.user.GHAvatarService;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryCallbackComponent;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class AssigneeCallbackComponent
implements RapidIssueEntryCallbackComponent {
    private static final Set<String> FIELDS = ImmutableSet.of((Object)"issue_assignee");
    private static final Pattern ACCEPTABLE_USER_INITIAL_RANGE = Pattern.compile("[\\u0000-\\u052F]");
    private static final ImmutableList<String> AUTO_AVATAR_COLORS_VALUES = ImmutableList.of((Object)"#815b3a", (Object)"#ea632b", (Object)"#f1a257", (Object)"#d39c3f", (Object)"#3b7fc4", (Object)"#4a6785", (Object)"#8eb021", (Object)"#7bc1a1", (Object)"#654982", (Object)"#ac707a", (Object)"#f15c75", (Object)"#f691b2", (Object[])new String[0]);
    private final ApplicationUser user;
    private final GHAvatarService avatarService;
    private final AvatarService jiraAvatarService;
    private Map<String, ApplicationUser> users = new HashMap<String, ApplicationUser>();
    private Map<String, String> avatars = new HashMap<String, String>();
    private Map<String, Boolean> hasCustomUserAvatars = new HashMap<String, Boolean>();

    public AssigneeCallbackComponent(ApplicationUser user, GHAvatarService avatarService, AvatarService jiraAvatarService) {
        this.user = user;
        this.avatarService = avatarService;
        this.jiraAvatarService = jiraAvatarService;
    }

    @Override
    public Set<String> getFields() {
        return FIELDS;
    }

    @Override
    public void processFieldData(Long issueId, String issueKey, IssueFieldValueProvider data, RapidIssueEntry entry) {
        boolean hasCustomUserAvatar;
        String assigneeKey = data.get("issue_assignee");
        if (assigneeKey == null) {
            return;
        }
        ApplicationUser assignee = this.users.get(assigneeKey);
        if (assignee == null) {
            assignee = ApplicationUsers.byKey((String)assigneeKey);
            this.users.put(assigneeKey, assignee);
        }
        if (assignee == null) {
            return;
        }
        entry.assignee = assignee.getName();
        entry.assigneeName = assignee.getDisplayName();
        if (this.jiraAvatarService.isGravatarEnabled()) {
            hasCustomUserAvatar = true;
        } else if (!this.hasCustomUserAvatars.containsKey(assigneeKey)) {
            hasCustomUserAvatar = this.jiraAvatarService.hasCustomUserAvatar(this.user, assignee);
            this.hasCustomUserAvatars.put(assigneeKey, hasCustomUserAvatar);
        } else {
            hasCustomUserAvatar = this.hasCustomUserAvatars.get(assigneeKey);
        }
        entry.hasCustomUserAvatar = hasCustomUserAvatar;
        if (hasCustomUserAvatar) {
            String avatarUrl = this.avatars.get(assigneeKey);
            if (avatarUrl == null && !this.avatars.containsKey(assigneeKey)) {
                avatarUrl = this.avatarService.getLargeAvatarURL(assignee);
                this.avatars.put(assigneeKey, avatarUrl);
            }
            entry.avatarUrl = avatarUrl;
        } else {
            entry.autoUserAvatar = this.buildAutoUserAvatar(assignee);
        }
    }

    private RapidIssueEntry.AutoUserAvatar buildAutoUserAvatar(ApplicationUser user) {
        RapidIssueEntry.AutoUserAvatar autoUserAvatar = new RapidIssueEntry.AutoUserAvatar();
        String nameFirstChar = user.getDisplayName().substring(0, 1);
        autoUserAvatar.letter = ACCEPTABLE_USER_INITIAL_RANGE.matcher(nameFirstChar).matches() ? nameFirstChar : "";
        int colorIndex = Math.abs(user.getDisplayName().hashCode()) % AUTO_AVATAR_COLORS_VALUES.size();
        autoUserAvatar.color = (String)AUTO_AVATAR_COLORS_VALUES.get(colorIndex);
        return autoUserAvatar;
    }
}

