/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.tabs.editable.utils;

import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.jira.issue.Issue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstimationFieldApplicabilityValidator {
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;

    public boolean isEstimateFieldApplicableForIssue(StatisticsField estimateStatistic, Issue issue) {
        return this.estimateStatisticService.isEstimateStatisticValidAndEnabled(estimateStatistic) && !this.estimateStatisticService.isEstimateStatisticFieldAndNotApplicable(estimateStatistic, issue);
    }

    public boolean isTrackingFieldApplicableForIssue(StatisticsField trackingStatistic, Issue issue) {
        return this.trackingStatisticService.isTrackingStatisticValidAndEnabled(trackingStatistic) && !this.trackingStatisticService.isTrackingStatisticFieldAndNotApplicable(trackingStatistic, issue);
    }
}

