/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.tabs.editable.utils;

import com.atlassian.greenhopper.issue.detailsview.DelegationWebPanelModuleDescriptor;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelBean;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelBeanBuilder;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.IssueWebPanelRenderUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.jira.web.component.ModuleWebComponentFields;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webwork.action.Action;

@Service
public class DelegatedWebPanelFinder {
    @Autowired
    private ModuleWebComponentFields moduleWebComponentFields;
    @Autowired
    private ModuleWebComponent moduleWebComponent;
    @Autowired
    private PluginAccessor pluginAccessor;

    public List<WebPanelBean> findDelegatedPanels(Issue issue, Action action, ApplicationUser loggedInUser, I18nHelper i18nHelper, List<? extends DelegationWebPanelModuleDescriptor> webPanelModuleDescriptors) {
        IssueWebPanelRenderUtil issueWebPanelRenderUtil = new IssueWebPanelRenderUtil(loggedInUser, issue, action, null, this.moduleWebComponent);
        return webPanelModuleDescriptors.stream().map(webPanelModuleDescriptor -> this.getWebPanelBeanBuilder(issueWebPanelRenderUtil, i18nHelper, loggedInUser, this.toDelegateWebPanel((DelegationWebPanelModuleDescriptor)webPanelModuleDescriptor))).map(webPanelBeanBuilder -> webPanelBeanBuilder.buildWithHtml()).filter(webPanelBean -> webPanelBean != null).collect(Collectors.toList());
    }

    private WebPanelModuleDescriptor toDelegateWebPanel(DelegationWebPanelModuleDescriptor detailsViewWebPanel) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(detailsViewWebPanel.getDelegate());
        if (moduleDescriptor instanceof WebPanelModuleDescriptor) {
            return (WebPanelModuleDescriptor)moduleDescriptor;
        }
        throw new IllegalArgumentException("The delegated panel with the complete key ['" + detailsViewWebPanel.getDelegate() + "'] must be an instance of WebPanelModuleDescriptor");
    }

    private WebPanelBeanBuilder getWebPanelBeanBuilder(IssueWebPanelRenderUtil issueWebPanelRenderUtil, I18nHelper i18nHelper, ApplicationUser loggedInUser, WebPanelModuleDescriptor webPanel) {
        return new WebPanelBeanBuilder(this.moduleWebComponentFields, issueWebPanelRenderUtil, i18nHelper, loggedInUser, webPanel);
    }
}

