/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.rapid.issue.SubtaskEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.DetailsViewTab;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.EditableTabEntry;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.BaseEditableTabEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.EditableSubtasksTabEntry;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.EditableTabEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.query.Query;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EditableSubtasksTabEntryFactory
extends BaseEditableTabEntryFactory<EditableSubtasksTabEntry>
implements EditableTabEntryFactory {
    @Autowired
    private SearchService searchService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private SubtaskEntryFactory subtaskEntryFactory;
    @Autowired
    private IssueTypeSchemeManager issueTypeSchemeManager;
    @Autowired
    private RapidViewService rapidViewService;

    @Override
    public EditableTabEntry createEntry(Issue issue, Map<String, Object> rootContextMap) {
        boolean projectHasSubtaskTypes;
        EditableSubtasksTabEntry tabEntry = new EditableSubtasksTabEntry();
        tabEntry.tabId = this.getTab().name();
        ApplicationUser loggedInUser = this.getLoggedInUser(rootContextMap);
        StatisticsField trackingStatisticField = this.getTrackingField(rootContextMap);
        boolean bl = projectHasSubtaskTypes = !this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(issue.getProjectObject()).isEmpty();
        if (!issue.isSubTask() && projectHasSubtaskTypes) {
            ServiceOutcome<Pair<List<Issue>, Long>> outcome = this.getSubTasks(loggedInUser, this.getRapidViewId(rootContextMap), issue);
            if (!outcome.isValid()) {
                return tabEntry;
            }
            List subTasks = (List)outcome.getValue().first();
            tabEntry.subtaskEntries = subTasks.stream().map(subtask -> this.subtaskEntryFactory.createSubtaskEntry(loggedInUser, (Issue)subtask, trackingStatisticField)).collect(Collectors.toList());
            tabEntry.totalSubtaskCount = (Long)outcome.getValue().second();
        }
        return tabEntry;
    }

    @Override
    protected EditableSubtasksTabEntry newTabEntry() {
        return new EditableSubtasksTabEntry();
    }

    @Override
    protected DetailsViewTab getCurrentTab() {
        return DetailsViewTab.SUB_TASKS;
    }

    @Override
    protected void populateTabParticularAttributes(Issue issue, EditableSubtasksTabEntry tabEntry, Map<String, Object> rootContextMap) {
        throw new UnsupportedOperationException("This should not be called for creating, since this factory will have to override the whole createEntry method!");
    }

    private ServiceOutcome<Pair<List<Issue>, Long>> getSubTasks(ApplicationUser user, Long rapidViewId, Issue issue) {
        RapidView rapidView = this.rapidViewService.getRapidView(user, rapidViewId).getValue();
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder().where().issueParent().eq(issue.getId()).endWhere();
        ServiceOutcome<Long> totalCount = this.searchService.searchCount(user, builder.buildQuery());
        if (!totalCount.isValid()) {
            return ServiceOutcomeImpl.error(totalCount);
        }
        if (totalCount.get().equals(0L)) {
            return ServiceOutcomeImpl.ok(Pair.of(Collections.emptyList(), (Object)totalCount.get()));
        }
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        builder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where().defaultAnd().issueParent().eq(issue.getId()).endWhere();
        ServiceOutcome<SearchResults<Issue>> search = this.searchService.search(user, builder.buildQuery());
        if (!search.isValid()) {
            return ServiceOutcomeImpl.error(search);
        }
        return ServiceOutcomeImpl.ok(Pair.of((Object)search.getValue().getResults(), (Object)totalCount.getValue()));
    }
}

