/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingService;
import com.atlassian.greenhopper.web.rapid.issue.fields.AggregateRemainingEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.IssueKeyFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.NumberCustomFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.OriginalEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.ParentIssueKeyFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.RemainingEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SubTasksRemainingEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SummaryFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.DetailsViewTab;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.EditableTabEntry;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.BaseEditableTabEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.EditableHeaderTabEntry;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.EditableTabEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.utils.EstimationFieldApplicabilityValidator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.TimeEstimateSystemField;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EditableHeaderTabEntryFactory
extends BaseEditableTabEntryFactory<EditableHeaderTabEntry>
implements EditableTabEntryFactory {
    @Autowired
    private SearchService searchService;
    @Autowired
    private AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    @Autowired
    private EstimationFieldApplicabilityValidator estimationFieldApplicabilityValidator;
    @Autowired
    private I18nHelper.BeanFactory i18nHelperFactory;
    @Autowired
    private TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory;
    @Autowired
    private TimeTrackingService timeTrackingService;
    @Autowired
    public FieldHelper fieldHelper;
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final Map<String, FieldEntryFactory> BASE_FIELD_IDS = MapBuilder.build((Object)"issuekey", (Object)new IssueKeyFieldEntryFactory(), (Object)"parentissuekey", (Object)new ParentIssueKeyFieldEntryFactory(), (Object)"summary", (Object)new SummaryFieldEntryFactory());
    @Autowired
    private RapidViewQueryService rapidViewQueryService;

    @Override
    public EditableTabEntry createEntry(Issue issue, Map<String, Object> rootContextMap) {
        EditableHeaderTabEntry tabEntry = new EditableHeaderTabEntry();
        tabEntry.tabId = this.getTab().name();
        tabEntry.fields = this.createHeaderFieldEntries(issue, rootContextMap);
        return tabEntry;
    }

    @Override
    protected EditableHeaderTabEntry newTabEntry() {
        return new EditableHeaderTabEntry();
    }

    @Override
    protected DetailsViewTab getCurrentTab() {
        return DetailsViewTab.HEADER;
    }

    @Override
    protected void populateTabParticularAttributes(Issue issue, EditableHeaderTabEntry tabEntry, Map<String, Object> rootContextMap) {
        throw new UnsupportedOperationException("This should not be called for creating, since this factory will have to override the whole createEntry method!");
    }

    private List<FieldEntry> createHeaderFieldEntries(Issue issue, Map<String, Object> rootContextMap) {
        StatisticsField trackingField;
        I18n2 i18n = this.getI18n();
        ApplicationUser user = this.getLoggedInUser(rootContextMap);
        List fieldEntries = this.BASE_FIELD_IDS.entrySet().stream().filter(entry -> ((FieldEntryFactory)entry.getValue()).isFieldValid(issue)).map(entry -> ((FieldEntryFactory)entry.getValue()).createViewEntry(i18n, issue, user)).filter(fieldEntry -> fieldEntry != null).collect(Collectors.toList());
        StatisticsField estimateField = this.getEstimateField(rootContextMap);
        if (this.estimationFieldApplicabilityValidator.isEstimateFieldApplicableForIssue(estimateField, issue)) {
            fieldEntries.add(this.createEstimateStatisticFieldEntry(user, i18n, issue, estimateField.getField(), this.fieldHelper));
        }
        if (this.estimationFieldApplicabilityValidator.isTrackingFieldApplicableForIssue(trackingField = this.getTrackingField(rootContextMap), issue)) {
            fieldEntries.addAll(this.createTrackingStatisticFields(user, i18n, issue, trackingField.getField(), this.fieldHelper, this.getRapidView(rootContextMap)));
        }
        return fieldEntries.stream().filter(fieldEntry -> fieldEntry != null).collect(Collectors.toList());
    }

    private FieldEntry createEstimateStatisticFieldEntry(ApplicationUser user, I18n2 i18n, Issue issue, Field estimateField, FieldHelper fieldHelper) {
        if (estimateField instanceof CustomField) {
            CustomField statisticField = (CustomField)estimateField;
            NumberCustomFieldEntryFactory field = new NumberCustomFieldEntryFactory(statisticField, fieldHelper);
            return field.createViewEntry(i18n, issue, user);
        }
        if (estimateField instanceof OriginalEstimateSystemField) {
            OriginalEstimateFieldEntryFactory originalEstimateField = new OriginalEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.timeTrackingService, fieldHelper);
            return originalEstimateField.createViewEntry(i18n, issue, user);
        }
        return null;
    }

    private List<FieldEntry> createTrackingStatisticFields(ApplicationUser user, I18n2 i18n, Issue issue, Field trackingField, FieldHelper fieldHelper, RapidView rapidView) {
        ArrayList<FieldEntry> viewEntriesToAdd = new ArrayList<FieldEntry>();
        if (trackingField instanceof TimeEstimateSystemField) {
            RemainingEstimateFieldEntryFactory remainingEstimateField = new RemainingEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.timeTrackingService, fieldHelper);
            FieldEntry viewEntry = remainingEstimateField.createViewEntry(i18n, issue, user);
            viewEntriesToAdd.add(viewEntry);
            List<Issue> subTasks = this.getSubTasks(user, issue.getId(), rapidView);
            if (CollectionUtils.isNotEmpty(subTasks)) {
                AggregateRemainingEstimateFieldEntryFactory aggregateRemainingEstimateField = new AggregateRemainingEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.aggregateTimeTrackingCalculatorFactory, this.timeTrackingService, null);
                viewEntriesToAdd.add(aggregateRemainingEstimateField.createViewEntry(i18n, issue, subTasks, user));
                SubTasksRemainingEstimateFieldEntryFactory subTasksRemainingEstimateField = new SubTasksRemainingEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.aggregateTimeTrackingCalculatorFactory, this.timeTrackingService, null);
                viewEntriesToAdd.add(subTasksRemainingEstimateField.createViewEntry(i18n, issue, subTasks, user));
            }
        }
        return viewEntriesToAdd;
    }

    private List<Issue> getSubTasks(ApplicationUser user, Long issueId, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return Collections.emptyList();
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where().defaultAnd().issueParent().eq(issueId).endWhere();
        ServiceOutcome<SearchResults<Issue>> search = this.searchService.search(user, builder.buildQuery());
        if (!search.isValid()) {
            return Collections.emptyList();
        }
        return search.getValue().getResults();
    }
}

