/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory;

import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.DetailsViewTab;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.BaseEditableTabEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.EditableCommentTabEntry;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.EditableTabEntryFactory;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.Issue;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EditableCommentTabEntryFactory
extends BaseEditableTabEntryFactory<EditableCommentTabEntry>
implements EditableTabEntryFactory {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private CommentService commentService;

    @Override
    protected EditableCommentTabEntry newTabEntry() {
        return new EditableCommentTabEntry();
    }

    @Override
    protected DetailsViewTab getCurrentTab() {
        return DetailsViewTab.COMMENT;
    }

    @Override
    protected void populateTabParticularAttributes(Issue issue, EditableCommentTabEntry tabEntry, Map<String, Object> rootContextMap) {
        tabEntry.canCreateComment = this.permissionService.hasPermission(this.getLoggedInUser(rootContextMap), issue, 15);
        tabEntry.totalComments = this.commentService.getCommentsForUser(this.getLoggedInUser(rootContextMap), issue).size();
    }
}

