/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory;

import com.atlassian.greenhopper.issue.detailsview.DefaultIssueDetailsViewPanelModuleDescriptorImpl;
import com.atlassian.greenhopper.issue.detailsview.DelegationWebPanelModuleDescriptor;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailsCategory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.DetailsViewTab;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.EditableTabEntry;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.EditableTabSection;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.EditableTabEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.utils.DelegatedWebPanelFinder;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewFieldHelper;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.rest.v2.issue.LinkGroupBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import webwork.action.Action;

public abstract class BaseEditableTabEntryFactory<T extends EditableTabEntry>
implements EditableTabEntryFactory {
    @Autowired
    private DetailViewFieldHelper detailViewFieldHelper;
    @Autowired
    private WebResourceUrlProvider webResourceUrlProvider;
    @Autowired
    private WebInterfaceManager webInterfaceManager;
    @Autowired
    private DelegatedWebPanelFinder delegatedWebPanelFinder;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private JiraAuthenticationContext authenticationContext;

    @Override
    public EditableTabEntry createEntry(Issue issue, Map<String, Object> rootContextMap) {
        T tabEntry = this.newTabEntry();
        ((EditableTabEntry)tabEntry).tabId = this.getCurrentTab().name();
        ((EditableTabEntry)tabEntry).sections = this.buildSections(issue, this.getDisplayableWebPanelsByTab(this.getCurrentTab(), rootContextMap), rootContextMap);
        this.populateTabParticularAttributes(issue, tabEntry, rootContextMap);
        return tabEntry;
    }

    @Override
    public DetailsViewTab getTab() {
        return this.getCurrentTab();
    }

    protected abstract T newTabEntry();

    protected abstract DetailsViewTab getCurrentTab();

    protected abstract void populateTabParticularAttributes(Issue var1, T var2, Map<String, Object> var3);

    protected ApplicationUser getLoggedInUser(Map<String, Object> rootContextMap) {
        return (ApplicationUser)rootContextMap.get("user");
    }

    protected Long getRapidViewId(Map<String, Object> rootContextMap) {
        return this.getRapidView(rootContextMap).getId();
    }

    protected RapidView getRapidView(Map<String, Object> rootContextMap) {
        return (RapidView)rootContextMap.get("requestedRapidView");
    }

    protected StatisticsField getTrackingField(Map<String, Object> rootContextMap) {
        return (StatisticsField)rootContextMap.get("trackingStatisticField");
    }

    protected StatisticsField getEstimateField(Map<String, Object> rootContextMap) {
        return (StatisticsField)rootContextMap.get("estimateStatisticField");
    }

    protected I18n2 getI18n() {
        return this.i18nFactoryService.getI18n();
    }

    @VisibleForTesting
    protected List<EditableTabSection> buildSections(Issue issue, List<? extends WebPanelModuleDescriptor> webPanels, Map<String, Object> rootPanelContext) {
        List<EditableTabSection> sections = webPanels.stream().map(webPanel -> this.buildSection(issue, (WebPanelModuleDescriptor)webPanel, rootPanelContext)).filter(editableTabSection -> editableTabSection != null).collect(Collectors.toList());
        return sections;
    }

    @VisibleForTesting
    protected List<? extends WebPanelModuleDescriptor> getDisplayableWebPanelsByTab(DetailsViewTab detailsViewTab, Map<String, Object> rootContextMap) {
        return this.getWebPanelsByLocation(detailsViewTab.getLocation()).stream().filter(webPanelModuleDescriptor -> this.shouldShowPanel(detailsViewTab, (WebPanelModuleDescriptor)webPanelModuleDescriptor, rootContextMap)).collect(Collectors.toList());
    }

    private List<? extends WebPanelModuleDescriptor> getWebPanelsByLocation(String location) {
        return this.webInterfaceManager.getWebPanelDescriptors(location);
    }

    private boolean shouldShowPanel(DetailsViewTab tab, WebPanelModuleDescriptor webPanel, Map<String, Object> rootPanelContext) {
        if (webPanel instanceof DefaultIssueDetailsViewPanelModuleDescriptorImpl) {
            return this.shouldShowDefaultDetailsViewPanel(webPanel, tab, rootPanelContext);
        }
        return this.shouldShowConditionalPanel(webPanel, rootPanelContext);
    }

    private boolean shouldShowDefaultDetailsViewPanel(WebPanelModuleDescriptor webPanel, DetailsViewTab tab, Map<String, Object> rootPanelContext) {
        if (tab == DetailsViewTab.DETAILS) {
            String detailsSectionCategory = (String)webPanel.getParams().get("category");
            return this.isAnyFieldVisibleInCategory(FieldDetailsCategory.valueOf(detailsSectionCategory), rootPanelContext);
        }
        return true;
    }

    private boolean shouldShowConditionalPanel(WebPanelModuleDescriptor delegateWebPanel, Map<String, Object> rootPanelContext) {
        return delegateWebPanel.getCondition() == null || delegateWebPanel.getCondition().shouldDisplay(rootPanelContext);
    }

    private boolean isAnyFieldVisibleInCategory(FieldDetailsCategory requestedCategory, Map<String, Object> rootPanelContext) {
        List visibleFields = (List)rootPanelContext.getOrDefault("visibleFields", Collections.EMPTY_LIST);
        return CollectionUtils.isNotEmpty(this.detailViewFieldHelper.filterVisibleFieldsByCategory(visibleFields, requestedCategory));
    }

    @VisibleForTesting
    protected EditableTabSection buildSection(Issue issue, WebPanelModuleDescriptor webPanel, Map<String, Object> rootPanelContext) {
        return webPanel instanceof DelegationWebPanelModuleDescriptor ? this.buildSectionForDelegatePanel(issue, webPanel, rootPanelContext) : this.buildSectionForContextAwarePanel(webPanel, rootPanelContext);
    }

    private EditableTabSection buildSectionForContextAwarePanel(WebPanelModuleDescriptor webPanel, Map<String, Object> rootPanelContext) {
        EditableTabSection entry = new EditableTabSection();
        entry.providerKey = webPanel.getCompleteKey();
        WebLabel label = webPanel.getWebLabel();
        if (label != null) {
            entry.label = label.getDisplayableLabel(ExecutingHttpRequest.get(), rootPanelContext);
        }
        entry.html = ((WebPanel)webPanel.getModule()).getHtml(rootPanelContext);
        this.fillPanelIconic(entry, webPanel, rootPanelContext);
        entry.headerLinks = new LinkGroupBean.Builder().addLinks(Collections.emptyList()).addGroups(Collections.emptyList()).build();
        return entry;
    }

    private EditableTabSection buildSectionForDelegatePanel(Issue issue, WebPanelModuleDescriptor webPanelModule, Map<String, Object> rootPanelContext) {
        WebPanelBean delegate = this.getDelegatedPanel(issue, (DelegationWebPanelModuleDescriptor)webPanelModule);
        if (delegate == null) {
            return null;
        }
        EditableTabSection entry = new EditableTabSection();
        this.fillPanelIconic(entry, webPanelModule, rootPanelContext);
        entry.providerKey = delegate.getCompleteKey();
        entry.label = delegate.getLabel();
        entry.html = delegate.getHtml();
        entry.headerLinks = delegate.getHeaderLinks();
        return entry;
    }

    private WebPanelBean getDelegatedPanel(Issue issue, DelegationWebPanelModuleDescriptor webPanel) {
        List<WebPanelBean> delegateWebPanels = this.delegatedWebPanelFinder.findDelegatedPanels(issue, (Action)new IssueTabAction(), this.authenticationContext.getLoggedInUser(), this.authenticationContext.getI18nHelper(), Lists.newArrayList((Object[])new DelegationWebPanelModuleDescriptor[]{webPanel}));
        if (CollectionUtils.isEmpty(delegateWebPanels)) {
            return null;
        }
        return (WebPanelBean)delegateWebPanels.stream().findFirst().get();
    }

    private void fillPanelIconic(EditableTabSection sectionEntry, WebPanelModuleDescriptor webPanel, Map<String, Object> rootPanelContext) {
        WebLabel tooltip = webPanel.getTooltip();
        if (tooltip != null) {
            sectionEntry.toolTip = tooltip.getDisplayableLabel(ExecutingHttpRequest.get(), rootPanelContext);
        }
        sectionEntry.iconURL = this.getIconURL(webPanel);
        sectionEntry.titleCount = this.getEntityCount(webPanel, rootPanelContext);
        sectionEntry.iconFont = (String)webPanel.getParams().get("iconFont");
        sectionEntry.weight = webPanel.getWeight();
        sectionEntry.tabIconId = (String)webPanel.getParams().get("tabIconId");
        sectionEntry.renderHeader = !BooleanUtils.toBoolean((String)((String)webPanel.getParams().get("hideTabHeader")));
    }

    private String getIconURL(WebPanelModuleDescriptor webPanel) {
        for (ResourceDescriptor resource : webPanel.getResourceDescriptors()) {
            String name;
            if (!"download".equals(resource.getType()) || !(name = resource.getName()).startsWith("icon")) continue;
            return this.webResourceUrlProvider.getStaticPluginResourceUrl((ModuleDescriptor)webPanel, name, UrlMode.ABSOLUTE);
        }
        return null;
    }

    private Long getEntityCount(WebPanelModuleDescriptor webPanel, Map<String, Object> rootPanelContext) {
        ContextProvider contextProvider = webPanel.getContextProvider();
        if (contextProvider == null) {
            return null;
        }
        Map generatedMap = contextProvider.getContextMap(rootPanelContext);
        Object entityCount = generatedMap.get("atl.gh.issue.details.tab.count");
        return entityCount instanceof Long ? (Long)entityCount : null;
    }

    private class IssueTabAction
    extends GreenHopperWebActionSupport
    implements OperationContext {
        private IssueTabAction() {
        }

        @Override
        public I18n2 getI18n() {
            return BaseEditableTabEntryFactory.this.i18nFactoryService.getI18n(BaseEditableTabEntryFactory.this.authenticationContext.getLoggedInUser());
        }

        public Map<String, Object> getFieldValuesHolder() {
            return Maps.newHashMap();
        }

        public IssueOperation getIssueOperation() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

