/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.tabs;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.web.rapid.issue.tabs.TabModel;
import com.atlassian.greenhopper.web.rapid.issue.tabs.TabModelFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.DetailsViewTab;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.EditableTabEntry;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.EditableTabModel;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.factory.EditableTabEntryFactoryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class EditableTabModelFactory
implements TabModelFactory {
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    @Autowired
    private EditableTabEntryFactoryFactory editableTabEntryFactoryFactory;

    EditableTabModelFactory() {
    }

    @Override
    public TabModel createModel(RapidView rapidView, Issue issue, List<? extends Field> visibleFields, StatisticsField estimateField, StatisticsField trackingStatisticField) {
        Map<String, Object> rootPanelContext = this.getWebPanelContext(issue, visibleFields, rapidView, estimateField, trackingStatisticField);
        return new EditableTabModel(this.buildTabs(issue, rootPanelContext));
    }

    @Override
    public TabModel createModelPerTab(RapidView rapidView, Issue issue, List<? extends Field> visibleFields, StatisticsField estimateField, StatisticsField trackingStatisticField, DetailsViewTab detailsViewTab) {
        Map<String, Object> rootPanelContext = this.getWebPanelContext(issue, visibleFields, rapidView, estimateField, trackingStatisticField);
        return new EditableTabModel(this.editableTabEntryFactoryFactory.getFactoryForTab(detailsViewTab).createEntry(issue, rootPanelContext));
    }

    private List<EditableTabEntry> buildTabs(Issue issue, Map<String, Object> rootPanelContext) {
        return this.editableTabEntryFactoryFactory.getAllFactories().stream().map(editableTabEntryFactory -> editableTabEntryFactory.createEntry(issue, rootPanelContext)).collect(Collectors.toList());
    }

    private Map<String, Object> getWebPanelContext(Issue issue, List<? extends Field> visibleFields, RapidView rapidView, StatisticsField estimateField, StatisticsField trackingStatisticField) {
        ApplicationUser applicationUser = this.authenticationContext.getLoggedInUser();
        HashMap webPanelParams = MapBuilder.newBuilder().add((Object)"user", (Object)applicationUser).add((Object)"username", (Object)(applicationUser != null ? applicationUser.getName() : null)).add((Object)"project", (Object)issue.getProjectObject()).add((Object)"issue", (Object)issue).add((Object)"action", null).add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper()).add((Object)"requestedRapidView", (Object)rapidView).add((Object)"estimateStatisticField", (Object)estimateField).add((Object)"trackingStatisticField", (Object)trackingStatisticField).add((Object)"visibleFields", visibleFields).toHashMap();
        webPanelParams.put("helper", new JiraHelper(ExecutingHttpRequest.get(), issue.getProjectObject(), (Map)webPanelParams));
        return webPanelParams;
    }
}

