/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.statistics;

import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.web.rapid.issue.statistics.ChangeHistoryStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueStatisticValueResolver;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.statistics.TimeTrackingStatisticsMapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraDurationUtils;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

class TimeEstimateStatisticValueResolver
implements DocumentStatisticValueResolver,
IssueStatisticValueResolver,
ChangeHistoryStatisticValueResolver {
    private final StatisticsField estimationStatistic;
    private final TimeTrackingStatisticsMapper timeTrackingStatisticsMapper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final JiraDurationUtils jiraDurationUtils;

    TimeEstimateStatisticValueResolver(StatisticsField estimationStatistic, TimeTrackingStatisticsMapper timeTrackingStatisticsMapper, JiraAuthenticationContext jiraAuthenticationContext, JiraDurationUtils jiraDurationUtils) {
        this.estimationStatistic = estimationStatistic;
        this.timeTrackingStatisticsMapper = timeTrackingStatisticsMapper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jiraDurationUtils = jiraDurationUtils;
    }

    @Override
    public StatisticsField getStatisticsField() {
        return this.estimationStatistic;
    }

    @Override
    public String getDocumentId() {
        return this.estimationStatistic.getDocumentId();
    }

    @Override
    public Double getValue(String documentValue) {
        if (!StringUtils.isEmpty((CharSequence)documentValue)) {
            Double value = null;
            Long longValue = (Long)this.timeTrackingStatisticsMapper.getValueFromLuceneField(documentValue);
            if (longValue != null) {
                value = longValue.doubleValue();
            }
            return value;
        }
        return null;
    }

    @Override
    public Double getValue(Issue issue) {
        Double value = null;
        Long originalEstimate = issue.getOriginalEstimate();
        if (originalEstimate != null) {
            value = originalEstimate.doubleValue();
        }
        return value;
    }

    @Override
    public String getText(Double value) {
        return this.getOriginalEstimateStr(value.longValue(), this.jiraAuthenticationContext.getLocale());
    }

    @Override
    public String getChangeItemField() {
        return "timeoriginalestimate";
    }

    @Override
    public Double getChangeItemValue(String value, String valueString) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getOriginalEstimateStr(Long duration, Locale locale) {
        return this.jiraDurationUtils.getShortFormattedDuration(duration, locale);
    }
}

