/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.statistics;

import com.atlassian.greenhopper.jira.JIRAResource;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.issue.statistics.ChangeHistoryStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.HistoricalEstimateStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.InvalidStatisticsFieldValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueCountValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.NumberCFStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.StatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.TimeEstimateStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.TimeTrackingStatisticValueResolver;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.TimeEstimateSystemField;
import com.atlassian.jira.issue.statistics.TimeTrackingStatisticsMapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.velocity.NumberTool;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticValueResolverFactory {
    @JIRAResource
    private JiraDurationUtils jiraDurationUtils;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    private final TimeTrackingStatisticsMapper timeTrackingStatisticsMapper = new TimeTrackingStatisticsMapper("timeoriginalestimate");

    public DocumentStatisticValueResolver forEstimationStatisticInDocument(StatisticsField estimationStatistic) {
        return (DocumentStatisticValueResolver)this.forEstimationStatistic(estimationStatistic);
    }

    public DocumentStatisticValueResolver forTrackingStatisticInDocument(StatisticsField trackingStatistic) {
        return (DocumentStatisticValueResolver)this.forTrackingStatistic(trackingStatistic);
    }

    public IssueStatisticValueResolver forEstimationStatisticInIssue(StatisticsField estimationStatistic) {
        return (IssueStatisticValueResolver)this.forEstimationStatistic(estimationStatistic);
    }

    public ChangeHistoryStatisticValueResolver forEstimationStatisticInChangeHistory(StatisticsField estimationStatistic) {
        return (ChangeHistoryStatisticValueResolver)this.forEstimationStatistic(estimationStatistic);
    }

    private <T extends StatisticValueResolver> T forEstimationStatistic(StatisticsField estimationStatistic) {
        if (!estimationStatistic.isValid() || !estimationStatistic.isEnabled()) {
            return (T)new InvalidStatisticsFieldValueResolver(estimationStatistic);
        }
        if (!estimationStatistic.isFieldBased()) {
            return (T)new IssueCountValueResolver(estimationStatistic);
        }
        Field field = estimationStatistic.getField();
        if (field instanceof CustomField) {
            return (T)new NumberCFStatisticValueResolver(estimationStatistic, this.createNumberTool());
        }
        if (field instanceof OriginalEstimateSystemField) {
            return (T)new TimeEstimateStatisticValueResolver(estimationStatistic, this.timeTrackingStatisticsMapper, this.jiraAuthenticationContext, this.jiraDurationUtils);
        }
        throw new IllegalArgumentException("Should not have received an estimationStatistic that wasn't field based");
    }

    private <T extends StatisticValueResolver> T forTrackingStatistic(StatisticsField trackingStatistic) {
        if (!trackingStatistic.isValid() || !trackingStatistic.isEnabled()) {
            return (T)new InvalidStatisticsFieldValueResolver(trackingStatistic);
        }
        if (!trackingStatistic.isFieldBased()) {
            return (T)new IssueCountValueResolver(trackingStatistic);
        }
        Field field = trackingStatistic.getField();
        if (field instanceof CustomField) {
            return (T)new NumberCFStatisticValueResolver(trackingStatistic, this.createNumberTool());
        }
        if (field instanceof TimeEstimateSystemField) {
            return (T)new TimeTrackingStatisticValueResolver(trackingStatistic, this.timeTrackingStatisticsMapper, this.jiraAuthenticationContext, this.jiraDurationUtils);
        }
        throw new IllegalArgumentException("Should not have received an trackingStatistic that wasn't field based");
    }

    public HistoricalEstimateStatisticValueResolver forHistoricalEstimateStatisticValue(StatisticsField estimationStatistic, Sprint sprint, Map<String, List<BurndownChange>> historyData, Collection<String> mappedStatusIds) {
        return new HistoricalEstimateStatisticValueResolver(estimationStatistic, sprint, historyData, mappedStatusIds);
    }

    private NumberTool createNumberTool() {
        return new NumberTool(this.jiraAuthenticationContext.getLocale());
    }
}

