/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.statistics;

import com.atlassian.greenhopper.service.issue.callback.AbstractCompoundDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueFieldValueProvider;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StatisticFieldAggregationCallback
extends AbstractCompoundDataCallback {
    private final DocumentStatisticValueResolver statisticValueResolver;
    String documentId;
    private Map<Long, Double> valuePerIssue;

    public StatisticFieldAggregationCallback(DocumentStatisticValueResolver statisticValueResolver) {
        this.statisticValueResolver = statisticValueResolver;
        this.documentId = statisticValueResolver.getDocumentId();
        this.valuePerIssue = new HashMap<Long, Double>();
    }

    @Override
    public Set<String> getFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("issue_parenttask");
        fields.add(this.documentId);
        return fields;
    }

    @Override
    public void fieldData(Long issueId, String issueKey, IssueFieldValueProvider data) {
        Double value;
        Long parentId;
        Double statsValue = this.statisticValueResolver.getValue(data.get(this.documentId));
        if (statsValue == null) {
            return;
        }
        Long issueToAddTo = issueId;
        String parentIssueIdAsString = data.get("issue_parenttask");
        if (parentIssueIdAsString != null && (parentId = NumberUtils.toLong(parentIssueIdAsString)) != null) {
            issueToAddTo = parentId;
        }
        value = (value = this.valuePerIssue.get(issueToAddTo)) != null ? Double.valueOf(value + statsValue) : statsValue;
        this.valuePerIssue.put(issueToAddTo, value);
    }

    public Map<Long, Double> getValuePerIssue() {
        return this.valuePerIssue;
    }
}

