/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.statistics;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.web.rapid.issue.statistics.ChangeHistoryStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueStatisticValueResolver;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.util.velocity.NumberTool;
import org.apache.commons.lang3.StringUtils;

class NumberCFStatisticValueResolver
implements DocumentStatisticValueResolver,
IssueStatisticValueResolver,
ChangeHistoryStatisticValueResolver {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final StatisticsField statisticsField;
    private final NumberTool numberTool;
    private final CustomField numberCustomField;
    private final LuceneFieldSorter<Double> luceneFieldSorter;

    NumberCFStatisticValueResolver(StatisticsField statisticsField, NumberTool numberTool) {
        this.statisticsField = statisticsField;
        this.numberTool = numberTool;
        this.numberCustomField = (CustomField)statisticsField.getField();
        this.luceneFieldSorter = this.numberCustomField.getSorter();
    }

    @Override
    public StatisticsField getStatisticsField() {
        return this.statisticsField;
    }

    @Override
    public String getDocumentId() {
        return this.statisticsField.getDocumentId();
    }

    @Override
    public Double getValue(String documentValue) {
        if (this.luceneFieldSorter == null) {
            this.log.warn("Number custom field '%s' does not have a Searcher configured - cannot read values from index", this.numberCustomField.getId());
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)documentValue)) {
            return (Double)this.luceneFieldSorter.getValueFromLuceneField(documentValue);
        }
        return null;
    }

    @Override
    public Double getValue(Issue issue) {
        return (Double)issue.getCustomFieldValue(this.numberCustomField);
    }

    @Override
    public String getText(Double value) {
        return this.adjustDoubleZero(value, this.numberTool);
    }

    private String adjustDoubleZero(Double value, NumberTool numberTool) {
        String doubleString = numberTool.format((Object)value);
        return "-0".equals(doubleString) ? "0" : doubleString;
    }

    @Override
    public String getChangeItemField() {
        return this.numberCustomField.getName();
    }

    @Override
    public Double getChangeItemValue(String value, String stringValue) {
        if (StringUtils.isNotEmpty((CharSequence)stringValue)) {
            try {
                return Double.parseDouble(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

