/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.statistics;

import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;

public class IssueReopenedChecker {
    private final int historyIndex;
    private final List<BurndownChange> burndownChanges;
    private final boolean outsideSprint;

    private IssueReopenedChecker(int historyIndex, boolean outsideSprint, List<BurndownChange> burndownChanges) {
        this.historyIndex = historyIndex;
        this.burndownChanges = burndownChanges;
        this.outsideSprint = outsideSprint;
    }

    static Builder checkIssueReopened(List<BurndownChange> burndownChanges) {
        return new Builder(burndownChanges);
    }

    public boolean check() {
        int index;
        boolean issueHasBeenReopened = false;
        int n = index = this.historyIndex <= 1 ? 2 : this.historyIndex + 1;
        while (index < this.burndownChanges.size()) {
            BurndownChange burndownChange = this.burndownChanges.get(index);
            if (burndownChange.added != null && burndownChange.added == this.outsideSprint) break;
            if (burndownChange.column != null) {
                boolean bl = issueHasBeenReopened = BooleanUtils.isTrue((Boolean)burndownChange.column.notDone) && burndownChange.column.newStatus != null;
                if (issueHasBeenReopened) break;
            }
            ++index;
        }
        return issueHasBeenReopened;
    }

    static class Builder {
        private int historyIndex;
        private boolean outsideSprint;
        private final List<BurndownChange> burndownChanges;

        private Builder(List<BurndownChange> burndownChanges) {
            this.burndownChanges = burndownChanges;
        }

        Builder startFrom(int historyIndex) {
            this.historyIndex = historyIndex;
            return this;
        }

        Builder insideTheSprintUntilMovedToAnotherSprint() {
            this.outsideSprint = false;
            return this;
        }

        Builder outsideTheSprintUntiAddedBackToSprint() {
            this.outsideSprint = true;
            return this;
        }

        IssueReopenedChecker build() {
            return new IssueReopenedChecker(this.historyIndex, this.outsideSprint, this.burndownChanges);
        }
    }
}

